/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.sample;

import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NMessage2P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.sample.SampleService;
import org.marketcetera.util.ws.sample.SampleSession;
import org.marketcetera.util.ws.sample.SampleStatelessServiceImpl;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.RemoteCaller;
import org.marketcetera.util.ws.stateful.ServiceBaseImpl;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id$")
public class SampleServiceImpl
extends ServiceBaseImpl<SampleSession>
implements SampleService {
    private I18NMessage2P mGreeting;

    public SampleServiceImpl(SessionManager<SampleSession> sessionManager, I18NMessage2P greeting) {
        super(sessionManager);
        this.mGreeting = greeting;
    }

    private String helloImpl(SessionHolder<SampleSession> sessionHolder, String name) throws I18NException {
        SampleStatelessServiceImpl.checkName(name);
        SampleSession session = SampleSession.getSession(sessionHolder);
        return this.mGreeting.getText((Object)name, (Object)session.getCallCount());
    }

    @Override
    public String hello(ClientContext context, final String name) throws RemoteException {
        return (String)new RemoteCaller<SampleSession, String>(this.getSessionManager()){

            protected String call(ClientContext context, SessionHolder<SampleSession> sessionHolder) throws I18NException {
                return SampleServiceImpl.this.helloImpl((SessionHolder<SampleSession>)sessionHolder, name);
            }
        }.execute(context);
    }
}

