/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.collections;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
@NotThreadSafe
public class UnmodifiableDeque<T>
implements Deque<T> {
    private final Deque<T> innerCollection;

    public UnmodifiableDeque(Deque<T> inCollection) {
        if (inCollection == null) {
            throw new NullPointerException();
        }
        this.innerCollection = inCollection;
    }

    @Override
    public boolean addAll(Collection<? extends T> inC) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> inC) {
        return this.innerCollection.containsAll(inC);
    }

    @Override
    public boolean isEmpty() {
        return this.innerCollection.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> inC) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> inC) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.innerCollection.toArray();
    }

    @Override
    public <C> C[] toArray(C[] inA) {
        return this.innerCollection.toArray(inA);
    }

    @Override
    public boolean add(T inE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFirst(T inE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLast(T inE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object inO) {
        return this.innerCollection.contains(inO);
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new UnmodifiableIterator(this.innerCollection, true);
    }

    @Override
    public T element() {
        return this.innerCollection.element();
    }

    @Override
    public T getFirst() {
        return this.innerCollection.getFirst();
    }

    @Override
    public T getLast() {
        return this.innerCollection.getLast();
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator(this.innerCollection, false);
    }

    @Override
    public boolean offer(T inE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerFirst(T inE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerLast(T inE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        return this.innerCollection.peek();
    }

    @Override
    public T peekFirst() {
        return this.innerCollection.peekFirst();
    }

    @Override
    public T peekLast() {
        return this.innerCollection.peekLast();
    }

    @Override
    public T poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T pop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void push(T inE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object inO) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T removeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFirstOccurrence(Object inO) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T removeLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeLastOccurrence(Object inO) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.innerCollection.size();
    }

    @Override
    public int hashCode() {
        return this.innerCollection.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.innerCollection.equals(obj);
    }

    public String toString() {
        return this.innerCollection.toString();
    }

    @ClassVersion(value="$Id$")
    @ThreadSafe
    private class UnmodifiableIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private UnmodifiableIterator(Deque<T> inCollection, boolean inIsDescending) {
            this.iterator = inIsDescending ? inCollection.descendingIterator() : inCollection.iterator();
        }
    }
}

