/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.except.Messages;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
final class I18NExceptUtils {
    static String getDetail(I18NThrowable t) {
        String selfMessage = null;
        if (t.getI18NBoundMessage() != null) {
            selfMessage = t.getMessage();
        }
        String causeMessage = null;
        Throwable cause = t.getCause();
        if (cause != null) {
            causeMessage = cause instanceof I18NThrowable ? ((I18NThrowable)((Object)cause)).getDetail() : cause.getMessage();
        }
        if (selfMessage != null && causeMessage != null) {
            return selfMessage + " (" + causeMessage + ")";
        }
        if (selfMessage != null) {
            return selfMessage;
        }
        return causeMessage;
    }

    static String getLocalizedDetail(I18NThrowable t) {
        String selfMessage = null;
        if (t.getI18NBoundMessage() != null) {
            selfMessage = t.getLocalizedMessage();
        }
        String causeMessage = null;
        Throwable cause = t.getCause();
        if (cause != null) {
            causeMessage = cause instanceof I18NThrowable ? ((I18NThrowable)((Object)cause)).getLocalizedDetail() : cause.getLocalizedMessage();
        }
        if (selfMessage != null && causeMessage != null) {
            return Messages.COMBINE_MESSAGES.getText(selfMessage, causeMessage);
        }
        if (selfMessage != null) {
            return selfMessage;
        }
        return causeMessage;
    }

    private I18NExceptUtils() {
    }
}

