/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NExceptUtils;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.LogUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class I18NException
extends RuntimeException
implements I18NThrowable {
    private static final long serialVersionUID = 1L;
    private I18NBoundMessage mMessage;

    public I18NException() {
    }

    public I18NException(Throwable cause) {
        super(cause);
    }

    public I18NException(I18NBoundMessage message) {
        super(LogUtils.getSimpleMessage(message));
        this.mMessage = message;
    }

    public I18NException(Throwable cause, I18NBoundMessage message) {
        super(LogUtils.getSimpleMessage(message), cause);
        this.mMessage = message;
    }

    @Override
    public String getLocalizedMessage() {
        if (this.getI18NBoundMessage() == null) {
            return super.getMessage();
        }
        return this.getI18NBoundMessage().getText();
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage();
    }

    @Override
    public String getDetail() {
        return I18NExceptUtils.getDetail(this);
    }

    @Override
    public String getLocalizedDetail() {
        return I18NExceptUtils.getLocalizedDetail(this);
    }

    @Override
    public I18NBoundMessage getI18NBoundMessage() {
        return this.mMessage;
    }

    public int hashCode() {
        return ExceptUtils.getHashCode(this);
    }

    public boolean equals(Object other) {
        return ExceptUtils.areEqual(this, other);
    }
}

