/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.exec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.exec.Disposition;
import org.marketcetera.util.exec.ExecResult;
import org.marketcetera.util.exec.InputThread;
import org.marketcetera.util.exec.Messages;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public final class Exec {
    public static ExecResult run(File directory, Disposition disposition, String ... args) throws I18NException {
        Process process;
        OutputStream out;
        String command = args[0];
        Thread consumer = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(args);
            if (directory != null) {
                builder.directory(directory);
            }
            builder.redirectErrorStream(true);
            boolean closeOut = false;
            if (disposition == Disposition.MEMORY) {
                out = new ByteArrayOutputStream();
                closeOut = true;
            } else {
                out = disposition == Disposition.STDOUT ? System.out : System.err;
            }
            process = builder.start();
            consumer = new InputThread(command, process.getInputStream(), out, closeOut);
            consumer.start();
        }
        catch (Throwable t) {
            if (consumer != null) {
                consumer.interrupt();
            }
            throw ExceptUtils.wrap(t, new I18NBoundMessage1P(Messages.CANNOT_EXECUTE, (Serializable)((Object)command)));
        }
        try {
            process.waitFor();
            int exitValue = process.exitValue();
            consumer.join();
            consumer = null;
            byte[] capture = null;
            if (disposition == Disposition.MEMORY) {
                capture = ((ByteArrayOutputStream)out).toByteArray();
            }
            ExecResult execResult = new ExecResult(exitValue, capture);
            return execResult;
        }
        catch (Throwable t) {
            if (consumer != null) {
                consumer.interrupt();
            }
            throw ExceptUtils.wrap(t, new I18NBoundMessage1P(Messages.UNEXPECTED_TERMINATION, (Serializable)((Object)command)));
        }
        finally {
            process.destroy();
        }
    }

    public static ExecResult run(String name, Disposition disposition, String ... args) throws I18NException {
        File file = null;
        if (name != null) {
            file = new File(name);
        }
        return Exec.run(file, disposition, args);
    }
}

