/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.file.WriterWrapper;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public final class CopyCharsUtils {
    public static long copy(Reader in, boolean inSkipClose, Writer out, boolean outSkipClose) throws I18NException {
        try (CloseableRegistry registry = new CloseableRegistry();){
            ReaderWrapper inW = new ReaderWrapper(in, inSkipClose);
            registry.register(inW);
            WriterWrapper outW = new WriterWrapper(out, outSkipClose);
            registry.register(outW);
            long l = IOUtils.copyLarge((Reader)inW.getReader(), (Writer)outW.getWriter());
            return l;
        }
    }

    public static long copy(String in, String out) throws I18NException {
        try (CloseableRegistry registry = new CloseableRegistry();){
            ReaderWrapper inW = new ReaderWrapper(in);
            registry.register(inW);
            WriterWrapper outW = new WriterWrapper(out);
            registry.register(outW);
            long l = IOUtils.copyLarge((Reader)inW.getReader(), (Writer)outW.getWriter());
            return l;
        }
    }

    public static long copy(Reader in, boolean skipClose, String out) throws I18NException {
        try (CloseableRegistry registry = new CloseableRegistry();){
            ReaderWrapper inW = new ReaderWrapper(in, skipClose);
            registry.register(inW);
            WriterWrapper outW = new WriterWrapper(out);
            registry.register(outW);
            long l = IOUtils.copyLarge((Reader)inW.getReader(), (Writer)outW.getWriter());
            return l;
        }
    }

    public static long copy(String in, Writer out, boolean skipClose) throws I18NException {
        try (CloseableRegistry registry = new CloseableRegistry();){
            ReaderWrapper inW = new ReaderWrapper(in);
            registry.register(inW);
            WriterWrapper outW = new WriterWrapper(out, skipClose);
            registry.register(outW);
            long l = IOUtils.copyLarge((Reader)inW.getReader(), (Writer)outW.getWriter());
            return l;
        }
    }

    public static char[] copy(String name) throws I18NException {
        char[] cArray;
        ReaderWrapper inW = new ReaderWrapper(name);
        try {
            cArray = IOUtils.toCharArray((Reader)inW.getReader());
        }
        catch (Throwable throwable) {
            try {
                inW.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw ExceptUtils.wrap(ex, new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_DST, (Serializable)((Object)name)));
            }
        }
        inW.close();
        return cArray;
    }

    public static void copy(char[] data, String name) throws I18NException {
        try (WriterWrapper outW = new WriterWrapper(name);){
            outW.getWriter().write(data);
        }
        catch (IOException ex) {
            throw ExceptUtils.wrap(ex, new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_SRC, (Serializable)((Object)name)));
        }
    }

    private CopyCharsUtils() {
    }
}

