/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.file.SmartLinksDirectoryWalker;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class Deleter {
    private static void deleteWrap(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException(null, new I18NException(new I18NBoundMessage1P(Messages.CANNOT_DELETE, (Serializable)((Object)file.getAbsolutePath()))));
        }
    }

    public static void apply(File root) throws I18NException {
        new RecursiveDeleter().applyUnwrap(root);
    }

    public static void apply(String name) throws I18NException {
        Deleter.apply(new File(name));
    }

    @ClassVersion(value="$Id$")
    private static final class RecursiveDeleter
    extends SmartLinksDirectoryWalker {
        public RecursiveDeleter() {
            super(false);
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection results) throws IOException {
            Deleter.deleteWrap(directory);
        }

        protected void handleFile(File file, int depth, Collection results) throws IOException {
            Deleter.deleteWrap(file);
        }

        public void applyUnwrap(File file) throws I18NException {
            try {
                this.apply(file);
            }
            catch (IOException ex) {
                throw (I18NException)ex.getCause();
            }
        }
    }
}

