/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class InputStreamWrapper
implements Closeable {
    private InputStream mStream;
    private boolean mSkipClose;

    public InputStreamWrapper(String name) throws FileNotFoundException {
        if (name.equals(":stdin:")) {
            this.mStream = System.in;
            this.mSkipClose = true;
            return;
        }
        this.mStream = new FileInputStream(name);
    }

    public InputStreamWrapper(File file) throws FileNotFoundException {
        this.mStream = new FileInputStream(file);
    }

    public InputStreamWrapper(InputStream stream, boolean skipClose) {
        this.mStream = stream;
        this.mSkipClose = skipClose;
    }

    public InputStreamWrapper(InputStream stream) {
        this(stream, false);
    }

    @Override
    public void close() throws IOException {
        if (this.getStream() == null || this.getSkipClose()) {
            return;
        }
        this.getStream().close();
        this.mStream = null;
    }

    public InputStream getStream() {
        return this.mStream;
    }

    public boolean getSkipClose() {
        return this.mSkipClose;
    }
}

