/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeFileWriter;
import org.marketcetera.util.unicode.UnicodeOutputStreamWriter;

@ClassVersion(value="$Id$")
public class WriterWrapper
implements Closeable {
    private Writer mWriter;
    private boolean mSkipClose;

    public WriterWrapper(String name, SignatureCharset requestedSignatureCharset) throws FileNotFoundException {
        if (name.equals(":stdout:")) {
            this.mWriter = new UnicodeOutputStreamWriter((OutputStream)System.out, requestedSignatureCharset);
            this.mSkipClose = true;
            return;
        }
        if (name.equals(":stderr:")) {
            this.mWriter = new UnicodeOutputStreamWriter((OutputStream)System.err, requestedSignatureCharset);
            this.mSkipClose = true;
            return;
        }
        if (!name.startsWith(":append:")) {
            this.mWriter = new UnicodeFileWriter(name, requestedSignatureCharset);
            return;
        }
        this.mWriter = new UnicodeFileWriter(name.substring(":append:".length()), true, requestedSignatureCharset);
    }

    public WriterWrapper(String name) throws FileNotFoundException {
        this(name, null);
    }

    public WriterWrapper(File file, SignatureCharset requestedSignatureCharset) throws FileNotFoundException {
        this.mWriter = new UnicodeFileWriter(file, requestedSignatureCharset);
    }

    public WriterWrapper(File file) throws FileNotFoundException {
        this(file, null);
    }

    public WriterWrapper(Writer writer, boolean skipClose) {
        this.mWriter = writer;
        this.mSkipClose = skipClose;
    }

    public WriterWrapper(Writer writer) {
        this(writer, false);
    }

    @Override
    public void close() throws IOException {
        if (this.getWriter() == null) {
            return;
        }
        this.getWriter().flush();
        if (this.getSkipClose()) {
            return;
        }
        this.getWriter().close();
        this.mWriter = null;
    }

    public Writer getWriter() {
        return this.mWriter;
    }

    public boolean getSkipClose() {
        return this.mSkipClose;
    }
}

