/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.l10n;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.l10n.MessageInfo;
import org.marketcetera.util.l10n.MessageInfoProvider;
import org.marketcetera.util.l10n.Messages;
import org.marketcetera.util.l10n.PropertyMessageInfo;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class PropertiesFileInfo
implements MessageInfoProvider {
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\{(\\d+)");
    private I18NMessageProvider mProvider;
    private Locale mLocale;
    private List<MessageInfo> mMessageInfo;

    public PropertiesFileInfo(I18NMessageProvider provider, Locale locale) throws I18NException {
        this.mProvider = provider;
        this.mLocale = locale;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getProvider().getProviderId());
        builder.append("_messages");
        if (this.getLocale() != Locale.ROOT) {
            builder.append('_');
            builder.append(this.getLocale().toString());
        }
        builder.append(".properties");
        String fileName = builder.toString();
        InputStream stream = this.getProvider().getClass().getClassLoader().getResourceAsStream(fileName);
        if (stream == null) {
            throw new I18NException(new I18NBoundMessage1P(Messages.NONEXISTENT_RESOURCE, (Serializable)((Object)fileName)));
        }
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException ex) {
            throw new I18NException(ex, new I18NBoundMessage1P(Messages.LOADING_FAILED, (Serializable)((Object)fileName)));
        }
        this.mMessageInfo = new LinkedList<MessageInfo>();
        for (String key : properties.stringPropertyNames()) {
            String messageText = properties.getProperty(key);
            try {
                new MessageFormat(messageText, this.getLocale());
            }
            catch (IllegalArgumentException ex) {
                throw new I18NException(ex, new I18NBoundMessage1P(Messages.BAD_TEXT, (Serializable)((Object)messageText)));
            }
            Matcher matcher = PARAM_PATTERN.matcher(messageText);
            int maxIndex = -1;
            while (matcher.find()) {
                int index = Integer.valueOf(matcher.group(1));
                if (index <= maxIndex) continue;
                maxIndex = index;
            }
            this.mMessageInfo.add(new PropertyMessageInfo(key, maxIndex + 1, messageText));
        }
    }

    public PropertiesFileInfo(I18NMessageProvider provider) throws I18NException {
        this(provider, Locale.ROOT);
    }

    public I18NMessageProvider getProvider() {
        return this.mProvider;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    @Override
    public List<MessageInfo> getMessageInfo() {
        return this.mMessageInfo;
    }
}

