/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.CollectionUtils;

@ClassVersion(value="$Id$")
public class ActiveLocale {
    private static InheritableThreadLocal<Stack<Locale>> sThreadStack = new InheritableThreadLocal<Stack<Locale>>(){

        @Override
        protected Stack<Locale> initialValue() {
            Stack<Locale> stack = new Stack<Locale>();
            stack.push(null);
            return stack;
        }

        @Override
        protected Stack<Locale> childValue(Stack<Locale> parentStack) {
            Stack<Locale> stack = new Stack<Locale>();
            stack.push(CollectionUtils.getLastNonNull(parentStack));
            return stack;
        }
    };
    private static Locale sProcessLocale;

    static void clear() {
        Stack<Object> stack = new Stack<Object>();
        stack.push(null);
        sThreadStack.set(stack);
        ActiveLocale.setProcessLocale(null);
    }

    public static Locale getLocale() {
        Locale locale = (Locale)CollectionUtils.getLastNonNull((List)sThreadStack.get());
        if (locale != null) {
            return locale;
        }
        if (ActiveLocale.getProcessLocale() != null) {
            return ActiveLocale.getProcessLocale();
        }
        return Locale.getDefault();
    }

    public static void setProcessLocale(Locale locale) {
        sProcessLocale = locale;
    }

    public static Locale getProcessLocale() {
        return sProcessLocale;
    }

    public static void setThreadLocale(Locale locale) {
        Stack stack = (Stack)sThreadStack.get();
        stack.pop();
        stack.push(locale);
    }

    public static void pushLocale(Locale locale) {
        ((Stack)sThreadStack.get()).push(locale);
    }

    public static void popLocale() {
        ((Stack)sThreadStack.get()).pop();
    }

    public static void runWithLocale(Runnable runnable, Locale locale) {
        ActiveLocale.pushLocale(locale);
        try {
            runnable.run();
        }
        finally {
            ActiveLocale.popLocale();
        }
    }

    public static <V> V runWithLocale(Callable<V> callable, Locale locale) throws Exception {
        ActiveLocale.pushLocale(locale);
        try {
            V v = callable.call();
            return v;
        }
        finally {
            ActiveLocale.popLocale();
        }
    }

    private ActiveLocale() {
    }
}

