/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.i18n.MessageManager;
import org.apache.commons.i18n.MessageNotFoundException;
import org.apache.commons.i18n.MessageProvider;
import org.apache.commons.i18n.ResourceBundleMessageProvider;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.LogUtils;
import org.marketcetera.util.log.Messages;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class I18NMessageProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MESSAGE_FILE_EXTENSION = "_messages";
    private static final String MESSAGE_FILE_NOT_FOUND = "Message file missing: provider '{}'; base name '{}'";
    private static final String MESSAGE_NOT_FOUND = "Message missing: provider ''{0}''; id ''{1}''; entry ''{2}''; parameters {3}";
    private static final String UNEXPECTED_EXCEPTION_CONTEXT = "Abnormal exception: provider ''{0}''; id ''{1}''; entry ''{2}''; parameters {3}";
    private static final String UNEXPECTED_EXCEPTION_TRACE = "Abnormal exception: stack trace";
    private static final String CORRUPTED_STORE = "Corrupted/unavailable message map";
    private String mProviderId;

    public I18NMessageProvider(String providerId, ClassLoader classLoader) {
        this.mProviderId = providerId;
        try {
            this.init(classLoader);
        }
        catch (MessageNotFoundException ex) {
            SLF4JLoggerProxy.error((Object)this, MESSAGE_FILE_NOT_FOUND, this.getProviderId(), this.getBaseName());
            SLF4JLoggerProxy.error((Object)this, UNEXPECTED_EXCEPTION_TRACE, ex);
        }
    }

    public I18NMessageProvider(String providerId) {
        this(providerId, null);
    }

    private void init(ClassLoader classLoader) throws MessageNotFoundException {
        ResourceBundleMessageProvider provider = classLoader == null ? new ResourceBundleMessageProvider(this.getBaseName()) : new ResourceBundleMessageProvider(this.getBaseName(), classLoader);
        MessageManager.addMessageProvider((String)this.getProviderId(), (MessageProvider)provider);
    }

    public String getProviderId() {
        return this.mProviderId;
    }

    private String getBaseName() {
        return this.getProviderId() + MESSAGE_FILE_EXTENSION;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.init(null);
        }
        catch (MessageNotFoundException ex) {
            throw new IOException(Messages.MESSAGE_FILE_NOT_FOUND.getText(this.getProviderId(), this.getBaseName()), ex);
        }
    }

    public String getText(Locale locale, I18NMessage message, Object ... params) {
        String messageId = message.getMessageId();
        String entryId = message.getEntryId();
        try {
            return MessageManager.getText((String)this.getProviderId(), (String)messageId, (String)entryId, (Object[])params, (Locale)locale);
        }
        catch (Exception ex) {
            ExceptUtils.interrupt(ex);
            if (message == Messages.MESSAGE_NOT_FOUND || message == Messages.UNEXPECTED_EXCEPTION) {
                SLF4JLoggerProxy.error((Object)this, CORRUPTED_STORE);
                if (message == Messages.MESSAGE_NOT_FOUND) {
                    return MessageFormat.format(MESSAGE_NOT_FOUND, params);
                }
                SLF4JLoggerProxy.error((Object)this, UNEXPECTED_EXCEPTION_TRACE, ex);
                return MessageFormat.format(UNEXPECTED_EXCEPTION_CONTEXT, params);
            }
            String paramsText = LogUtils.getListText(params);
            if (ex instanceof MessageNotFoundException) {
                Messages.MESSAGE_NOT_FOUND.error(this, ex, this.getProviderId(), messageId, entryId, paramsText);
            } else {
                Messages.UNEXPECTED_EXCEPTION.error(this, ex, this.getProviderId(), messageId, entryId, paramsText);
                SLF4JLoggerProxy.error((Object)this, UNEXPECTED_EXCEPTION_TRACE, ex);
            }
            return LogUtils.getSimpleMessage(this, message, params);
        }
    }

    public String getText(I18NMessage message, Object ... params) {
        return this.getText(ActiveLocale.getLocale(), message, params);
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.getProviderId());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        I18NMessageProvider o = (I18NMessageProvider)other;
        return ObjectUtils.equals((Object)this.getProviderId(), (Object)o.getProviderId());
    }
}

