/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import org.marketcetera.util.misc.ClassVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

@ClassVersion(value="$Id$")
public final class SLF4JLoggerProxy {
    public static final String UNKNOWN_MESSAGE = "Unknown Message";
    public static final String UNKNOWN_LOGGER_NAME = "UNKNOWN";
    private static final Logger UNKNOWN_LOGGER = LoggerFactory.getLogger((String)"UNKNOWN");
    private static final String SELF_PROXY = SLF4JLoggerProxy.class.getName();

    private static Logger getLogger(Object category) {
        if (category == null) {
            return UNKNOWN_LOGGER;
        }
        if (category instanceof String) {
            return LoggerFactory.getLogger((String)((String)category));
        }
        if (category instanceof Class) {
            return LoggerFactory.getLogger((String)((Class)category).getName());
        }
        return LoggerFactory.getLogger((String)category.getClass().getName());
    }

    private static boolean log(Logger logger, String proxy, int level, String message) {
        return SLF4JLoggerProxy.log(logger, proxy, level, message, (Throwable)null);
    }

    private static boolean log(Logger logger, String proxy, int level, String message, Throwable throwable) {
        if (!(logger instanceof LocationAwareLogger)) {
            return false;
        }
        ((LocationAwareLogger)logger).log(null, proxy, level, message, new Object[0], throwable);
        return true;
    }

    private static boolean log(Logger logger, String proxy, int level, String message, Object[] params) {
        return SLF4JLoggerProxy.log(logger, proxy, level, null, message, params);
    }

    private static boolean log(Logger logger, String proxy, int level, Throwable throwable, String message, Object[] params) {
        if (!(logger instanceof LocationAwareLogger)) {
            return false;
        }
        ((LocationAwareLogger)logger).log(null, proxy, level, MessageFormatter.arrayFormat((String)message, (Object[])params).getMessage(), params, throwable);
        return true;
    }

    public static boolean isErrorEnabled(Object category) {
        return SLF4JLoggerProxy.getLogger(category).isErrorEnabled();
    }

    static void errorProxy(String proxy, Object category, String message) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isErrorEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 40, message)) {
            return;
        }
        logger.error(message);
    }

    public static void error(Object category, String message) {
        SLF4JLoggerProxy.errorProxy(SELF_PROXY, category, message);
    }

    static void errorProxy(String proxy, Object category, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isErrorEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 40, UNKNOWN_MESSAGE, throwable)) {
            return;
        }
        logger.error(UNKNOWN_MESSAGE, throwable);
    }

    public static void error(Object category, Throwable throwable) {
        SLF4JLoggerProxy.errorProxy(SELF_PROXY, category, throwable);
    }

    static void errorProxy(String proxy, Object category, String message, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isErrorEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 40, message, throwable)) {
            return;
        }
        logger.error(message, throwable);
    }

    public static void error(Object category, String message, Throwable throwable) {
        SLF4JLoggerProxy.errorProxy(SELF_PROXY, category, message, throwable);
    }

    static void errorProxy(String proxy, Object category, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isErrorEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 40, message, params)) {
            return;
        }
        logger.error(message, params);
    }

    public static void error(Object category, String message, Object ... params) {
        SLF4JLoggerProxy.errorProxy(SELF_PROXY, category, message, params);
    }

    static void errorProxy(String proxy, Object category, Throwable throwable, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isErrorEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 40, throwable, message, params)) {
            return;
        }
        logger.error(MessageFormatter.arrayFormat((String)message, (Object[])params).getMessage(), throwable);
    }

    public static void error(Object category, Throwable throwable, String message, Object ... params) {
        SLF4JLoggerProxy.errorProxy(SELF_PROXY, category, throwable, message, params);
    }

    public static boolean isWarnEnabled(Object category) {
        return SLF4JLoggerProxy.getLogger(category).isWarnEnabled();
    }

    static void warnProxy(String proxy, Object category, String message) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isWarnEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 30, message)) {
            return;
        }
        logger.warn(message);
    }

    public static void warn(Object category, String message) {
        SLF4JLoggerProxy.warnProxy(SELF_PROXY, category, message);
    }

    static void warnProxy(String proxy, Object category, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isWarnEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 30, UNKNOWN_MESSAGE, throwable)) {
            return;
        }
        logger.warn(UNKNOWN_MESSAGE, throwable);
    }

    public static void warn(Object category, Throwable throwable) {
        SLF4JLoggerProxy.warnProxy(SELF_PROXY, category, throwable);
    }

    static void warnProxy(String proxy, Object category, String message, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isWarnEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 30, message, throwable)) {
            return;
        }
        logger.warn(message, throwable);
    }

    public static void warn(Object category, String message, Throwable throwable) {
        SLF4JLoggerProxy.warnProxy(SELF_PROXY, category, message, throwable);
    }

    static void warnProxy(String proxy, Object category, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isWarnEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 30, message, params)) {
            return;
        }
        logger.warn(message, params);
    }

    public static void warn(Object category, String message, Object ... params) {
        SLF4JLoggerProxy.warnProxy(SELF_PROXY, category, message, params);
    }

    static void warnProxy(String proxy, Object category, Throwable throwable, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isWarnEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 30, throwable, message, params)) {
            return;
        }
        logger.warn(MessageFormatter.arrayFormat((String)message, (Object[])params).getMessage(), throwable);
    }

    public static void warn(Object category, Throwable throwable, String message, Object ... params) {
        SLF4JLoggerProxy.warnProxy(SELF_PROXY, category, throwable, message, params);
    }

    public static boolean isInfoEnabled(Object category) {
        return SLF4JLoggerProxy.getLogger(category).isInfoEnabled();
    }

    static void infoProxy(String proxy, Object category, String message) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 20, message)) {
            return;
        }
        logger.info(message);
    }

    public static void info(Object category, String message) {
        SLF4JLoggerProxy.infoProxy(SELF_PROXY, category, message);
    }

    static void infoProxy(String proxy, Object category, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 20, UNKNOWN_MESSAGE, throwable)) {
            return;
        }
        logger.info(UNKNOWN_MESSAGE, throwable);
    }

    public static void info(Object category, Throwable throwable) {
        SLF4JLoggerProxy.infoProxy(SELF_PROXY, category, throwable);
    }

    static void infoProxy(String proxy, Object category, String message, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 20, message, throwable)) {
            return;
        }
        logger.info(message, throwable);
    }

    public static void info(Object category, String message, Throwable throwable) {
        SLF4JLoggerProxy.infoProxy(SELF_PROXY, category, message, throwable);
    }

    static void infoProxy(String proxy, Object category, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 20, message, params)) {
            return;
        }
        logger.info(message, params);
    }

    public static void info(Object category, String message, Object ... params) {
        SLF4JLoggerProxy.infoProxy(SELF_PROXY, category, message, params);
    }

    static void infoProxy(String proxy, Object category, Throwable throwable, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 20, throwable, message, params)) {
            return;
        }
        logger.info(MessageFormatter.arrayFormat((String)message, (Object[])params).getMessage(), throwable);
    }

    public static void info(Object category, Throwable throwable, String message, Object ... params) {
        SLF4JLoggerProxy.infoProxy(SELF_PROXY, category, throwable, message, params);
    }

    public static boolean isDebugEnabled(Object category) {
        return SLF4JLoggerProxy.getLogger(category).isDebugEnabled();
    }

    static void debugProxy(String proxy, Object category, String message) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 10, message)) {
            return;
        }
        logger.debug(message);
    }

    public static void debug(Object category, String message) {
        SLF4JLoggerProxy.debugProxy(SELF_PROXY, category, message);
    }

    static void debugProxy(String proxy, Object category, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 10, UNKNOWN_MESSAGE, throwable)) {
            return;
        }
        logger.debug(UNKNOWN_MESSAGE, throwable);
    }

    public static void debug(Object category, Throwable throwable) {
        SLF4JLoggerProxy.debugProxy(SELF_PROXY, category, throwable);
    }

    static void debugProxy(String proxy, Object category, String message, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 10, message, throwable)) {
            return;
        }
        logger.debug(message, throwable);
    }

    public static void debug(Object category, String message, Throwable throwable) {
        SLF4JLoggerProxy.debugProxy(SELF_PROXY, category, message, throwable);
    }

    static void debugProxy(String proxy, Object category, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 10, message, params)) {
            return;
        }
        logger.debug(message, params);
    }

    public static void debug(Object category, String message, Object ... params) {
        SLF4JLoggerProxy.debugProxy(SELF_PROXY, category, message, params);
    }

    static void debugProxy(String proxy, Object category, Throwable throwable, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 10, throwable, message, params)) {
            return;
        }
        logger.debug(MessageFormatter.arrayFormat((String)message, (Object[])params).getMessage(), throwable);
    }

    public static void debug(Object category, Throwable throwable, String message, Object ... params) {
        SLF4JLoggerProxy.debugProxy(SELF_PROXY, category, throwable, message, params);
    }

    public static boolean isTraceEnabled(Object category) {
        return SLF4JLoggerProxy.getLogger(category).isTraceEnabled();
    }

    static void traceProxy(String proxy, Object category, String message) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isTraceEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 0, message)) {
            return;
        }
        logger.trace(message);
    }

    public static void trace(Object category, String message) {
        SLF4JLoggerProxy.traceProxy(SELF_PROXY, category, message);
    }

    static void traceProxy(String proxy, Object category, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isTraceEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 0, UNKNOWN_MESSAGE, throwable)) {
            return;
        }
        logger.trace(UNKNOWN_MESSAGE, throwable);
    }

    public static void trace(Object category, Throwable throwable) {
        SLF4JLoggerProxy.traceProxy(SELF_PROXY, category, throwable);
    }

    static void traceProxy(String proxy, Object category, String message, Throwable throwable) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isTraceEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 0, message, throwable)) {
            return;
        }
        logger.trace(message, throwable);
    }

    public static void trace(Object category, String message, Throwable throwable) {
        SLF4JLoggerProxy.traceProxy(SELF_PROXY, category, message, throwable);
    }

    static void traceProxy(String proxy, Object category, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isTraceEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 0, message, params)) {
            return;
        }
        logger.trace(message, params);
    }

    public static void trace(Object category, String message, Object ... params) {
        SLF4JLoggerProxy.traceProxy(SELF_PROXY, category, message, params);
    }

    static void traceProxy(String proxy, Object category, Throwable throwable, String message, Object ... params) {
        Logger logger = SLF4JLoggerProxy.getLogger(category);
        if (!logger.isTraceEnabled()) {
            return;
        }
        if (SLF4JLoggerProxy.log(logger, proxy, 0, throwable, message, params)) {
            return;
        }
        logger.trace(MessageFormatter.arrayFormat((String)message, (Object[])params).getMessage(), throwable);
    }

    public static void trace(Object category, Throwable throwable, String message, Object ... params) {
        SLF4JLoggerProxy.traceProxy(SELF_PROXY, category, throwable, message, params);
    }

    private SLF4JLoggerProxy() {
    }
}

