/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.nio.charset.Charset;
import java.util.Random;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.UCPFilter;
import org.marketcetera.util.misc.UCPFilterInfo;

@ClassVersion(value="$Id$")
public final class RandomStrings {
    public static final int DEFAULT_LEN_STR_CHARSET = 255;
    public static final int DEFAULT_LEN_STR_VALID = 255;
    public static final int DEFAULT_LEN_STR_DIGIT = 20;
    public static final int DEFAULT_LEN_STR_LETTER = 255;
    public static final int DEFAULT_LEN_STR_ALNUM = 255;
    public static final int DEFAULT_LEN_STR_ID = 255;
    private static Random sGenerator = new Random();

    public static void resetGeneratorRandom(long seed) {
        sGenerator.setSeed(seed);
    }

    public static long resetGeneratorRandom() {
        long seed = System.nanoTime();
        RandomStrings.resetGeneratorRandom(seed);
        return seed;
    }

    public static void resetGeneratorFixed() {
        RandomStrings.resetGeneratorRandom(0L);
    }

    public static int genUCP() {
        return sGenerator.nextInt(0x110000) + 0;
    }

    public static int genUCP(UCPFilter filter) {
        int[] ucps = UCPFilterInfo.getInfo(filter).getUCPs();
        return ucps[sGenerator.nextInt(ucps.length)];
    }

    public static int genUCPCharset(Charset cs) {
        return RandomStrings.genUCP(UCPFilter.forCharset(cs));
    }

    public static int genUCPDefCharset() {
        return RandomStrings.genUCP(UCPFilter.getDefaultCharset());
    }

    public static int genUCPFileSystem() {
        return RandomStrings.genUCP(UCPFilter.getFileSystemCharset());
    }

    public static int genUCPValid() {
        return RandomStrings.genUCP(UCPFilter.VALID);
    }

    public static int genUCPDigit() {
        return RandomStrings.genUCP(UCPFilter.DIGIT);
    }

    public static int genUCPLetter() {
        return RandomStrings.genUCP(UCPFilter.LETTER);
    }

    public static int genUCPAlNum() {
        return RandomStrings.genUCP(UCPFilter.ALNUM);
    }

    public static String genStr(UCPFilter filter, int len) {
        int[] ucps = UCPFilterInfo.getInfo(filter).getUCPs();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            builder.appendCodePoint(ucps[sGenerator.nextInt(ucps.length)]);
        }
        return builder.toString();
    }

    public static String genStrCharset(Charset cs, int len) {
        return RandomStrings.genStr(UCPFilter.forCharset(cs), len);
    }

    public static String genStrDefCharset(int len) {
        return RandomStrings.genStr(UCPFilter.getDefaultCharset(), len);
    }

    public static String genStrFileSystem(int len) {
        return RandomStrings.genStr(UCPFilter.getFileSystemCharset(), len);
    }

    public static String genStrValid(int len) {
        return RandomStrings.genStr(UCPFilter.VALID, len);
    }

    public static String genStrDigit(int len) {
        return RandomStrings.genStr(UCPFilter.DIGIT, len);
    }

    public static String genStrLetter(int len) {
        return RandomStrings.genStr(UCPFilter.LETTER, len);
    }

    public static String genStrAlNum(int len) {
        return RandomStrings.genStr(UCPFilter.ALNUM, len);
    }

    public static String genStrId(int len) {
        if (len <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.appendCodePoint(RandomStrings.genUCPLetter());
        if (len == 1) {
            return builder.toString();
        }
        builder.appendCodePoint(RandomStrings.genUCPDigit());
        if (len == 2) {
            return builder.toString();
        }
        builder.append(RandomStrings.genStrAlNum(len - 2));
        return builder.toString();
    }

    public static String genStrCharset(Charset cs) {
        return RandomStrings.genStrCharset(cs, sGenerator.nextInt(255) + 1);
    }

    public static String genStrDefCharset() {
        return RandomStrings.genStrDefCharset(sGenerator.nextInt(255) + 1);
    }

    public static String genStrFileSystem() {
        return RandomStrings.genStrFileSystem(sGenerator.nextInt(255) + 1);
    }

    public static String genStrValid() {
        return RandomStrings.genStrValid(sGenerator.nextInt(255) + 1);
    }

    public static String genStrDigit() {
        return RandomStrings.genStrDigit(sGenerator.nextInt(20) + 1);
    }

    public static String genStrLetter() {
        return RandomStrings.genStrLetter(sGenerator.nextInt(255) + 1);
    }

    public static String genStrAlNum() {
        return RandomStrings.genStrAlNum(sGenerator.nextInt(255) + 1);
    }

    public static String genStrId() {
        return RandomStrings.genStrId(sGenerator.nextInt(254) + 2);
    }

    private RandomStrings() {
    }

    static {
        RandomStrings.resetGeneratorRandom();
    }
}

