/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public final class StringUtils {
    public static int lengthUCP(String s) {
        return s.codePointCount(0, s.length());
    }

    public static String fromUCP(int[] ucps) {
        return new String(ucps, 0, ucps.length);
    }

    public static String fromUCP(int ucp) {
        return StringUtils.fromUCP(new int[]{ucp});
    }

    public static int[] toUCPArray(String s) {
        int c;
        if (s == null) {
            return null;
        }
        int[] result = new int[StringUtils.lengthUCP(s)];
        int j = 0;
        for (int i = 0; i < s.length(); i += Character.charCount(c)) {
            c = s.codePointAt(i);
            result[j++] = c;
        }
        return result;
    }

    public static String toUCPArrayStr(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean addSpace = false;
        for (int c : StringUtils.toUCPArray(s)) {
            if (addSpace) {
                builder.append(' ');
            }
            builder.append("U+");
            builder.append(Integer.toHexString(c));
            addSpace = true;
        }
        return builder.toString().toUpperCase();
    }

    public static boolean isValid(int ucp) {
        return Character.isDefined(ucp) && !Character.isISOControl(ucp) && (55296 > ucp || ucp > 57343);
    }

    private StringUtils() {
    }
}

