/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.StringUtils;

@ClassVersion(value="$Id$")
public abstract class UCPFilter {
    public static final UCPFilter VALID = new UCPFilter(){

        @Override
        public boolean isAcceptable(int ucp) {
            return StringUtils.isValid(ucp);
        }
    };
    public static final UCPFilter CHAR = new UCPFilter(){

        @Override
        public boolean isAcceptable(int ucp) {
            return 0 <= ucp && ucp <= 65535;
        }
    };
    public static final UCPFilter DIGIT = new UCPFilter(){

        @Override
        public boolean isAcceptable(int ucp) {
            return Character.isDigit(ucp);
        }
    };
    public static final UCPFilter LETTER = new UCPFilter(){

        @Override
        public boolean isAcceptable(int ucp) {
            return Character.isLetter(ucp);
        }
    };
    public static final UCPFilter ALNUM = new UCPFilter(){

        @Override
        public boolean isAcceptable(int ucp) {
            return Character.isLetterOrDigit(ucp);
        }
    };
    private static final HashMap<Charset, UCPFilter> mMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UCPFilter forCharset(Charset cs) {
        HashMap<Charset, UCPFilter> hashMap = mMap;
        synchronized (hashMap) {
            UCPFilter filter = mMap.get(cs);
            if (filter != null) {
                return filter;
            }
            filter = new UCPCharsetFilter(cs);
            mMap.put(cs, filter);
            return filter;
        }
    }

    public static final UCPFilter getDefaultCharset() {
        return UCPFilter.forCharset(Charset.defaultCharset());
    }

    public static final UCPFilter getFileSystemCharset() {
        return UCPFilter.forCharset(Charset.forName(System.getProperty("file.encoding")));
    }

    public abstract boolean isAcceptable(int var1);

    @ClassVersion(value="$Id$")
    private static final class UCPCharsetFilter
    extends UCPFilter {
        private CharsetEncoder mEncoder;

        public UCPCharsetFilter(Charset cs) {
            this.mEncoder = cs.newEncoder();
        }

        @Override
        public boolean isAcceptable(int ucp) {
            return this.mEncoder.canEncode(StringUtils.fromUCP(ucp));
        }
    }
}

