/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.util.HashMap;
import java.util.Vector;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.CollectionUtils;
import org.marketcetera.util.misc.UCPFilter;

@ClassVersion(value="$Id$")
public class UCPFilterInfo {
    private static final HashMap<UCPFilter, UCPFilterInfo> mMap = new HashMap();
    private int[] mUCPs;

    private UCPFilterInfo(UCPFilter filter) {
        Vector<Integer> ucps = new Vector<Integer>();
        for (int ucp = 0; ucp <= 0x10FFFF; ++ucp) {
            if (!filter.isAcceptable(ucp)) continue;
            ucps.add(ucp);
        }
        this.mUCPs = CollectionUtils.toArray(ucps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UCPFilterInfo getInfo(UCPFilter filter) {
        HashMap<UCPFilter, UCPFilterInfo> hashMap = mMap;
        synchronized (hashMap) {
            UCPFilterInfo info = mMap.get(filter);
            if (info != null) {
                return info;
            }
            info = new UCPFilterInfo(filter);
            mMap.put(filter, info);
            return info;
        }
    }

    public int[] getUCPs() {
        return this.mUCPs;
    }
}

