/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.quickfix;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.quickfix.AnalyzedField;
import org.marketcetera.util.quickfix.Messages;
import quickfix.DataDictionary;
import quickfix.Field;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.StringField;
import quickfix.field.MsgType;

@ClassVersion(value="$Id$")
public class AnalyzedMessage {
    private final List<AnalyzedField> mHeader = new LinkedList<AnalyzedField>();
    private final List<AnalyzedField> mBody = new LinkedList<AnalyzedField>();
    private final List<AnalyzedField> mTrailer = new LinkedList<AnalyzedField>();
    private Exception mValidationException;

    public AnalyzedMessage(DataDictionary qDict, Message qMsg) {
        String msgType = null;
        try {
            msgType = qMsg.getHeader().getField((StringField)new MsgType()).getValue();
        }
        catch (FieldNotFound ex) {
            Messages.MISSING_TYPE.error(this, ex, qMsg);
            return;
        }
        AnalyzedMessage.analyzeFields(qDict, qDict, (FieldMap)qMsg, "HEADER", qMsg.getHeader().iterator(), this.mHeader);
        AnalyzedMessage.analyzeFields(qDict, qDict, (FieldMap)qMsg, msgType, qMsg.iterator(), this.mBody);
        AnalyzedMessage.analyzeFields(qDict, qDict, (FieldMap)qMsg, "TRAILER", qMsg.getTrailer().iterator(), this.mTrailer);
        try {
            qDict.validate(qMsg);
        }
        catch (Exception ex) {
            ExceptUtils.interrupt(ex);
            this.mValidationException = ex;
        }
    }

    static void analyzeFields(DataDictionary nameQDict, DataDictionary scopeQDict, FieldMap qMap, String msgType, Iterator<?> qFields, List<AnalyzedField> list) {
        while (qFields.hasNext()) {
            list.add(new AnalyzedField(nameQDict, scopeQDict, qMap, msgType, (Field)qFields.next()));
        }
    }

    static void printFields(PrintStream stream, String prefix, List<AnalyzedField> list) {
        for (AnalyzedField field : list) {
            stream.println();
            field.print(stream, prefix);
        }
    }

    private void printSection(PrintStream stream, I18NBoundMessage title, List<AnalyzedField> list) {
        if (list.size() == 0) {
            return;
        }
        stream.println();
        stream.print(title.getText());
        AnalyzedMessage.printFields(stream, " ", list);
    }

    public List<AnalyzedField> getHeader() {
        return this.mHeader;
    }

    public List<AnalyzedField> getBody() {
        return this.mBody;
    }

    public List<AnalyzedField> getTrailer() {
        return this.mTrailer;
    }

    public Exception getValidationException() {
        return this.mValidationException;
    }

    public void print(PrintStream stream) {
        if (this.getValidationException() != null) {
            stream.println();
            stream.println(Messages.VALIDATION_TITLE.getText());
            stream.print(" ");
            stream.print(this.getValidationException().getLocalizedMessage());
        }
        this.printSection(stream, Messages.HEADER_TITLE, this.getHeader());
        this.printSection(stream, Messages.BODY_TITLE, this.getBody());
        this.printSection(stream, Messages.TRAILER_TITLE, this.getTrailer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ByteArrayOutputStream outputStream;
        try (CloseableRegistry r = new CloseableRegistry();){
            outputStream = new ByteArrayOutputStream();
            r.register(outputStream);
            PrintStream printStream = new PrintStream(outputStream);
            r.register(printStream);
            this.print(printStream);
        }
        return new String(outputStream.toByteArray());
    }
}

