/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.spring;

import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.spring.Messages;

@ClassVersion(value="$Id$")
public abstract class LazyBean {
    private boolean mProcessed;
    private boolean mProcessing;

    private void setProcessed(boolean processed) {
        this.mProcessed = processed;
    }

    private boolean getProcessed() {
        return this.mProcessed;
    }

    private void setProcessing(boolean processing) {
        this.mProcessing = processing;
    }

    private boolean getProcessing() {
        return this.mProcessing;
    }

    protected void assertNotProcessed() throws I18NRuntimeException {
        if (this.getProcessed()) {
            throw new I18NRuntimeException(Messages.LAZY_ALREADY_PROCESSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureProcessed() {
        LazyBean lazyBean = this;
        synchronized (lazyBean) {
            if (this.getProcessed()) {
                return;
            }
            if (this.getProcessing()) {
                throw new I18NRuntimeException(Messages.LAZY_IN_PROCESS);
            }
            this.setProcessing(true);
            try {
                this.process();
            }
            finally {
                this.setProcessing(false);
            }
            this.setProcessed(true);
        }
    }

    protected abstract void process();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceProcess() {
        LazyBean lazyBean = this;
        synchronized (lazyBean) {
            this.setProcessed(false);
            this.ensureProcessed();
        }
    }
}

