/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.Messages;
import org.marketcetera.util.unicode.Serialization;
import org.marketcetera.util.unicode.SignatureCharset;

@ClassVersion(value="$Id$")
public enum DecodingStrategy {
    UTF8_DEFAULT(new Serialization[]{Serialization.UTF8N, Serialization.UTF8, Serialization.UTF16, Serialization.UTF32}),
    UTF16_DEFAULT(new Serialization[]{Serialization.UTF16, Serialization.UTF8, Serialization.UTF32}),
    UTF32_DEFAULT(new Serialization[]{Serialization.UTF32, Serialization.UTF8, Serialization.UTF16}),
    SIG_REQ(new Serialization[]{Serialization.UTF8, Serialization.UTF16BE_REQ, Serialization.UTF16LE_REQ, Serialization.UTF32BE_REQ, Serialization.UTF32LE_REQ});

    private final Serialization[] mSerializations;

    private DecodingStrategy(Serialization[] serializations) {
        this.mSerializations = serializations;
    }

    public Serialization[] getSerializations() {
        return this.mSerializations;
    }

    public SignatureCharset getPrefixMatch(byte[] data) {
        return Serialization.getPrefixMatch(this.getSerializations(), data);
    }

    public String decode(byte[] data) throws I18NException {
        if (data == null) {
            return null;
        }
        SignatureCharset sc = this.getPrefixMatch(data);
        if (sc == null) {
            throw new I18NException(Messages.NO_SIGNATURE_MATCHES);
        }
        return sc.decode(data);
    }
}

