/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.apache.commons.lang.ArrayUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public enum Signature {
    NONE(ArrayUtils.EMPTY_BYTE_ARRAY),
    UTF8(new byte[]{-17, -69, -65}),
    UTF16BE(new byte[]{-2, -1}),
    UTF16LE(new byte[]{-1, -2}),
    UTF32BE(new byte[]{0, 0, -2, -1}),
    UTF32LE(new byte[]{-1, -2, 0, 0});

    public static final Signature[] EMPTY_ARRAY;
    private final byte[] mMark;

    private Signature(byte[] mark) {
        this.mMark = mark;
    }

    public static int getLongestLength() {
        int max = -1;
        for (Signature signature : Signature.values()) {
            int len = signature.getLength();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    public static Signature getPrefixMatch(Signature[] candidates, byte[] data) {
        int max = -1;
        Signature result = null;
        for (Signature signature : candidates) {
            int len;
            if (!signature.prefixMatch(data) || (len = signature.getLength()) <= max) continue;
            result = signature;
            max = len;
        }
        return result;
    }

    public byte[] getMark() {
        return this.mMark;
    }

    public int getLength() {
        return this.getMark().length;
    }

    public boolean prefixMatch(byte[] data) {
        if (data.length < this.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            if (data[i] == this.getMark()[i]) continue;
            return false;
        }
        return true;
    }

    static {
        EMPTY_ARRAY = new Signature[0];
    }
}

