/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.Messages;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeOutputStreamWriter;

@ClassVersion(value="$Id$")
public class UnicodeFileWriter
extends UnicodeOutputStreamWriter {
    public UnicodeFileWriter(String fileName) throws FileNotFoundException {
        super(new FileOutputStream(fileName));
    }

    public UnicodeFileWriter(String fileName, SignatureCharset requestedSignatureCharset) throws FileNotFoundException {
        super((OutputStream)new FileOutputStream(fileName), requestedSignatureCharset);
    }

    public UnicodeFileWriter(String fileName, Reader reader) throws IOException {
        super((OutputStream)new FileOutputStream(fileName), reader);
    }

    public UnicodeFileWriter(String fileName, boolean append) throws FileNotFoundException {
        super(new FileOutputStream(fileName, append));
    }

    public UnicodeFileWriter(String fileName, boolean append, SignatureCharset requestedSignatureCharset) throws FileNotFoundException {
        super((OutputStream)new FileOutputStream(fileName, append), requestedSignatureCharset, UnicodeFileWriter.shouldWriteSignature(fileName, append));
    }

    public UnicodeFileWriter(String fileName, boolean append, Reader reader) throws IOException {
        super((OutputStream)new FileOutputStream(fileName, append), reader, UnicodeFileWriter.shouldWriteSignature(fileName, append));
    }

    public UnicodeFileWriter(File file) throws FileNotFoundException {
        super(new FileOutputStream(file));
    }

    public UnicodeFileWriter(File file, SignatureCharset requestedSignatureCharset) throws FileNotFoundException {
        super((OutputStream)new FileOutputStream(file), requestedSignatureCharset);
    }

    public UnicodeFileWriter(File file, Reader reader) throws IOException {
        super((OutputStream)new FileOutputStream(file), reader);
    }

    public UnicodeFileWriter(File file, boolean append) throws FileNotFoundException {
        super(new FileOutputStream(file, append));
    }

    public UnicodeFileWriter(File file, boolean append, SignatureCharset requestedSignatureCharset) throws FileNotFoundException {
        super((OutputStream)new FileOutputStream(file, append), requestedSignatureCharset, UnicodeFileWriter.shouldWriteSignature(file, append));
    }

    public UnicodeFileWriter(File file, boolean append, Reader reader) throws IOException {
        super((OutputStream)new FileOutputStream(file, append), reader, UnicodeFileWriter.shouldWriteSignature(file, append));
    }

    public UnicodeFileWriter(FileDescriptor fd) {
        super(new FileOutputStream(fd));
    }

    public UnicodeFileWriter(FileDescriptor fd, SignatureCharset requestedSignatureCharset) {
        super((OutputStream)new FileOutputStream(fd), requestedSignatureCharset);
    }

    public UnicodeFileWriter(FileDescriptor fd, Reader reader) throws IOException {
        super((OutputStream)new FileOutputStream(fd), reader);
    }

    private static boolean shouldWriteSignature(File file, boolean append) {
        if (!append) {
            return true;
        }
        try {
            return file.length() == 0L;
        }
        catch (SecurityException ex) {
            Messages.CANNOT_GET_LENGTH.warn(UnicodeFileWriter.class, ex, file.getName());
            return true;
        }
    }

    private static boolean shouldWriteSignature(String fileName, boolean append) {
        return UnicodeFileWriter.shouldWriteSignature(new File(fileName), append);
    }
}

