/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.Messages;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.SignatureCharset;

@ClassVersion(value="$Id$")
public class UnicodeInputStreamReader
extends Reader {
    private PushbackInputStream mStream;
    private InputStreamReader mReader;
    private DecodingStrategy mDecodingStrategy;
    private SignatureCharset mRequestedSignatureCharset;
    private SignatureCharset mSignatureCharset;

    public UnicodeInputStreamReader(InputStream stream) {
        super(stream);
        this.mStream = new PushbackInputStream(stream, Signature.getLongestLength());
    }

    public UnicodeInputStreamReader(InputStream stream, SignatureCharset requestedSignatureCharset) {
        this(stream);
        this.mRequestedSignatureCharset = requestedSignatureCharset;
    }

    public UnicodeInputStreamReader(InputStream stream, DecodingStrategy decodingStrategy) {
        this(stream);
        this.mDecodingStrategy = decodingStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer target) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mReader.read(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mReader.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mReader.read(cbuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mReader.read(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mReader.skip(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.mStream == null) {
                throw new IOException(Messages.STREAM_CLOSED.getText());
            }
            if (this.mReader == null) {
                return false;
            }
            return this.mReader.ready();
        }
    }

    @Override
    public boolean markSupported() {
        try {
            this.init();
        }
        catch (IOException ex) {
            Messages.STREAM_ACCESS_ERROR.error(this, ex);
            return false;
        }
        return this.mReader.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            this.mReader.mark(readAheadLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.mStream == null) {
                return;
            }
            if (this.mReader != null) {
                this.mReader.close();
            }
            this.mStream.close();
            this.mStream = null;
        }
    }

    public DecodingStrategy getDecodingStrategy() {
        return this.mDecodingStrategy;
    }

    public SignatureCharset getRequestedSignatureCharset() {
        return this.mRequestedSignatureCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCharset getSignatureCharset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mSignatureCharset;
        }
    }

    private void init() throws IOException {
        if (this.mStream == null) {
            throw new IOException(Messages.STREAM_CLOSED.getText());
        }
        if (this.mReader != null) {
            return;
        }
        if (this.getDecodingStrategy() == null) {
            this.mSignatureCharset = this.getRequestedSignatureCharset();
        } else {
            byte[] consumed = new byte[Signature.getLongestLength()];
            int count = this.mStream.read(consumed);
            if (count == -1) {
                count = 0;
            }
            byte[] header = Arrays.copyOf(consumed, count);
            this.mSignatureCharset = this.getDecodingStrategy().getPrefixMatch(header);
            this.mStream.unread(header);
        }
        if (this.mSignatureCharset != null && !this.mSignatureCharset.isSupported()) {
            this.mSignatureCharset = null;
        }
        if (this.mSignatureCharset != null) {
            int len = this.mSignatureCharset.getSignature().getLength();
            long skipped = 1L;
            for (long left = (long)len; left > 0L && skipped > 0L; left -= skipped) {
                skipped = this.mStream.skip(left);
            }
            this.mReader = new InputStreamReader((InputStream)this.mStream, this.mSignatureCharset.getCharset().getCharset());
        } else {
            this.mReader = new InputStreamReader(this.mStream);
        }
    }
}

