/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.Messages;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeInputStreamReader;

@ClassVersion(value="$Id$")
public class UnicodeOutputStreamWriter
extends Writer {
    private OutputStream mStream;
    private OutputStreamWriter mWriter;
    private SignatureCharset mRequestedSignatureCharset;
    private SignatureCharset mSignatureCharset;
    private boolean mWriteSignature = true;

    public UnicodeOutputStreamWriter(OutputStream stream) {
        super(stream);
        this.mStream = stream;
    }

    protected UnicodeOutputStreamWriter(OutputStream stream, SignatureCharset requestedSignatureCharset, boolean writeSignature) {
        this(stream);
        this.mRequestedSignatureCharset = requestedSignatureCharset;
        this.mWriteSignature = writeSignature;
    }

    public UnicodeOutputStreamWriter(OutputStream stream, SignatureCharset requestedSignatureCharset) {
        this(stream, requestedSignatureCharset, true);
    }

    protected UnicodeOutputStreamWriter(OutputStream stream, Reader reader, boolean writeSignature) throws IOException {
        this(stream);
        if (reader instanceof UnicodeInputStreamReader) {
            this.mRequestedSignatureCharset = ((UnicodeInputStreamReader)reader).getSignatureCharset();
            this.mWriteSignature = writeSignature;
        }
    }

    public UnicodeOutputStreamWriter(OutputStream stream, Reader reader) throws IOException {
        this(stream, reader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            this.mWriter.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            this.mWriter.write(cbuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            this.mWriter.write(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            this.mWriter.write(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            this.mWriter.write(str, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence csq) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mWriter.append(csq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mWriter.append(csq, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mWriter.append(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            this.mWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.mStream == null) {
                return;
            }
            if (this.mWriter != null) {
                this.mWriter.close();
            }
            this.mStream.close();
            this.mStream = null;
        }
    }

    public SignatureCharset getRequestedSignatureCharset() {
        return this.mRequestedSignatureCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCharset getSignatureCharset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.init();
            return this.mSignatureCharset;
        }
    }

    private void init() throws IOException {
        if (this.mStream == null) {
            throw new IOException(Messages.STREAM_CLOSED.getText());
        }
        if (this.mWriter != null) {
            return;
        }
        this.mSignatureCharset = this.getRequestedSignatureCharset();
        if (this.mSignatureCharset != null && !this.mSignatureCharset.isSupported()) {
            this.mSignatureCharset = null;
        }
        if (this.mSignatureCharset != null) {
            if (this.mWriteSignature) {
                this.mStream.write(this.mSignatureCharset.getSignature().getMark());
            }
            this.mWriter = new OutputStreamWriter(this.mStream, this.mSignatureCharset.getCharset().getCharset());
        } else {
            this.mWriter = new OutputStreamWriter(this.mStream);
        }
    }
}

