/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.StatelessRemoteCall;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.tags.TagFilter;
import org.marketcetera.util.ws.tags.ValidSessionTagFilter;

@ClassVersion(value="$Id$")
public class RemoteCall<T>
extends StatelessRemoteCall {
    private final SessionManager<T> mSessionManager;
    private final TagFilter mSessionIdFilter;

    public RemoteCall(TagFilter versionIdFilter, TagFilter appIdFilter, TagFilter clientIdFilter, SessionManager<T> sessionManager, TagFilter sessionIdFilter) {
        super(versionIdFilter, appIdFilter, clientIdFilter);
        this.mSessionManager = sessionManager;
        this.mSessionIdFilter = sessionIdFilter;
    }

    public RemoteCall(SessionManager<T> sessionManager) {
        this.mSessionManager = sessionManager;
        this.mSessionIdFilter = this.getSessionManager() != null ? RemoteCall.getDefaultSessionIdFilter(this.getSessionManager()) : null;
    }

    public SessionManager<T> getSessionManager() {
        return this.mSessionManager;
    }

    public static <T> ValidSessionTagFilter<T> getDefaultSessionIdFilter(SessionManager<T> sessionManager) {
        return new ValidSessionTagFilter<T>(sessionManager);
    }

    public TagFilter getSessionIdFilter() {
        return this.mSessionIdFilter;
    }

    protected SessionHolder<T> getSessionHolder(ClientContext context) throws I18NException {
        this.assertFilterMatch(context);
        SessionId sessionId = context.getSessionId();
        RemoteCall.assertFilterMatch(this.getSessionIdFilter(), sessionId);
        if (sessionId == null || this.getSessionManager() == null) {
            return null;
        }
        SessionHolder<T> holder = this.getSessionManager().get(sessionId);
        return holder;
    }
}

