/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import java.util.Locale;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.RemoteCall;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.tags.TagFilter;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id$")
public abstract class RemoteRunner<S>
extends RemoteCall<S> {
    public RemoteRunner(TagFilter versionIdFilter, TagFilter appIdFilter, TagFilter clientIdFilter, SessionManager<S> sessionManager, TagFilter sessionIdFilter) {
        super(versionIdFilter, appIdFilter, clientIdFilter, sessionManager, sessionIdFilter);
    }

    public RemoteRunner(SessionManager<S> sessionManager) {
        super(sessionManager);
    }

    public void execute(ClientContext context) throws RemoteException {
        Locale locale = null;
        if (context.getLocale() != null) {
            locale = (Locale)context.getLocale().getRaw();
        }
        try {
            this.startCall(context);
            ActiveLocale.pushLocale(locale);
            try {
                this.run(context, this.getSessionHolder(context));
            }
            finally {
                ActiveLocale.popLocale();
            }
            this.handleSuccess(context);
        }
        catch (Throwable t) {
            throw this.wrapFailure(context, t);
        }
    }

    protected abstract void run(ClientContext var1, SessionHolder<S> var2) throws Exception;
}

