/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateless.StatelessClientContext;

@ClassVersion(value="$Id$")
public class SessionHolder<T> {
    private final String mUser;
    private final StatelessClientContext mCreationContext;
    private long mLastAccess;
    private T mSession;

    public SessionHolder(String user, StatelessClientContext creationContext) {
        this.mUser = user;
        this.mCreationContext = creationContext;
    }

    public String getUser() {
        return this.mUser;
    }

    public StatelessClientContext getCreationContext() {
        return this.mCreationContext;
    }

    void markAccess() {
        this.mLastAccess = System.currentTimeMillis();
    }

    long getLastAccess() {
        return this.mLastAccess;
    }

    public void setSession(T session) {
        this.mSession = session;
    }

    public T getSession() {
        return this.mSession;
    }
}

