/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.tags;

import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NMessage2P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.Tag;
import org.marketcetera.util.ws.tags.TagFilter;

@ClassVersion(value="$Id$")
public class EqualsTagFilter
implements TagFilter {
    private final Tag mTarget;
    private final I18NMessage2P mMessage;

    public EqualsTagFilter(Tag target, I18NMessage2P message) {
        this.mTarget = target;
        this.mMessage = message;
    }

    public Tag getTarget() {
        return this.mTarget;
    }

    public I18NMessage2P getMessage() {
        return this.mMessage;
    }

    @Override
    public void assertMatch(Tag tag) throws I18NException {
        if (ObjectUtils.equals((Object)tag, (Object)this.getTarget())) {
            return;
        }
        throw new I18NException(new I18NBoundMessage2P(this.getMessage(), (Serializable)this.getTarget(), (Serializable)tag));
    }
}

