/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.util.Date;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.wrappers.DualWrapper;
import org.marketcetera.util.ws.wrappers.Messages;

@ClassVersion(value="$Id$")
public class DateWrapper
extends DualWrapper<Date, Long>
implements Comparable<DateWrapper> {
    private static final long serialVersionUID = 1L;

    public DateWrapper(Date date) {
        super(date);
    }

    public DateWrapper() {
    }

    @Override
    protected void toRaw() {
        this.setRawOnly(new Date((Long)this.getMarshalled()));
    }

    @Override
    protected void toMarshalled() {
        this.setMarshalledOnly(((Date)this.getRaw()).getTime());
    }

    @Override
    public int compareTo(DateWrapper other) {
        if (this.getRaw() == null) {
            throw new NullPointerException(Messages.RECEIVER_WRAPS_NULL.getText());
        }
        if (other == null) {
            throw new NullPointerException(Messages.ARGUMENT_IS_NULL.getText());
        }
        if (other.getRaw() == null) {
            throw new NullPointerException(Messages.ARGUMENT_WRAPS_NULL.getText());
        }
        return ((Date)this.getRaw()).compareTo((Date)other.getRaw());
    }
}

