/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.bind.annotation.XmlTransient;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.wrappers.BaseWrapper;

@ClassVersion(value="$Id$")
public abstract class DualWrapper<R, M>
extends BaseWrapper<R>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private M mMarshalled;

    public DualWrapper(R raw) {
        this.setRaw(raw);
    }

    protected DualWrapper() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getMarshalled());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setMarshalled(in.readObject());
    }

    protected void setRawOnly(R raw) {
        this.setValue(raw);
    }

    public void setRaw(R raw) {
        this.setRawOnly(raw);
        if (this.getRaw() == null) {
            this.setMarshalledOnly(null);
        } else {
            this.toMarshalled();
            if (this.getMarshalled() == null) {
                this.setRawOnly(null);
            }
        }
    }

    @XmlTransient
    public R getRaw() {
        return (R)this.getValue();
    }

    protected void setMarshalledOnly(M marshalled) {
        this.mMarshalled = marshalled;
    }

    public void setMarshalled(M marshalled) {
        this.setMarshalledOnly(marshalled);
        if (this.getMarshalled() == null) {
            this.setRawOnly(null);
        } else {
            this.toRaw();
            if (this.getRaw() == null) {
                this.setMarshalledOnly(null);
            }
        }
    }

    public M getMarshalled() {
        return this.mMarshalled;
    }

    protected abstract void toRaw();

    protected abstract void toMarshalled();
}

