/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class MarshalledLocale
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String mLanguage;
    private String mCountry;
    private String mVariant;

    public MarshalledLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.setLanguage(locale.getLanguage());
        this.setCountry(locale.getCountry());
        this.setVariant(locale.getVariant());
    }

    protected MarshalledLocale() {
    }

    public void setLanguage(String language) {
        this.mLanguage = language;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public void setCountry(String country) {
        this.mCountry = country;
    }

    public String getCountry() {
        return this.mCountry;
    }

    public void setVariant(String variant) {
        this.mVariant = variant;
    }

    public String getVariant() {
        return this.mVariant;
    }

    public Locale toLocale() {
        if (this.getLanguage() == null) {
            return null;
        }
        if (this.getCountry() == null) {
            return new Locale(this.getLanguage());
        }
        if (this.getVariant() == null) {
            return new Locale(this.getLanguage(), this.getCountry());
        }
        return new Locale(this.getLanguage(), this.getCountry(), this.getVariant());
    }

    public String toString() {
        return ObjectUtils.toString((Object)this.toLocale());
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.toLocale());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        MarshalledLocale o = (MarshalledLocale)other;
        return ObjectUtils.equals((Object)this.toLocale(), (Object)o.toLocale());
    }
}

