/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.wrappers.RemoteProxyException;
import org.marketcetera.util.ws.wrappers.SerWrapper;

@ClassVersion(value="$Id$")
public class RemoteProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Throwable mThrowable;
    private SerWrapper<Throwable> mWrapper;
    private String[] mTraceCapture;
    private String mServerMessage;
    private String mServerString;
    private String mServerName;

    public RemoteProperties(Throwable throwable) {
        this.setTransientThrowable(throwable);
        if (this.getTransientThrowable() == null) {
            return;
        }
        this.setWrapper(new SerWrapper<Throwable>(this.getTransientThrowable()));
        this.setTraceCapture(ExceptionUtils.getStackFrames((Throwable)this.getTransientThrowable()));
        if (this.getTransientThrowable() instanceof I18NThrowable) {
            this.setServerMessage(((I18NThrowable)((Object)this.getTransientThrowable())).getLocalizedDetail());
        } else {
            this.setServerMessage(this.getTransientThrowable().getLocalizedMessage());
        }
        this.setServerString(this.getTransientThrowable().toString());
        this.setServerName(this.getTransientThrowable().getClass().getName());
    }

    public RemoteProperties() {
    }

    private void setTransientThrowable(Throwable throwable) {
        this.mThrowable = throwable;
    }

    @XmlTransient
    private Throwable getTransientThrowable() {
        return this.mThrowable;
    }

    public void setWrapper(SerWrapper<Throwable> wrapper) {
        this.mWrapper = wrapper;
    }

    public SerWrapper<Throwable> getWrapper() {
        return this.mWrapper;
    }

    public void setTraceCapture(String[] traceCapture) {
        this.mTraceCapture = traceCapture;
    }

    public String[] getTraceCapture() {
        return this.mTraceCapture;
    }

    public void setServerMessage(String serverMessage) {
        this.mServerMessage = serverMessage;
    }

    public String getServerMessage() {
        return this.mServerMessage;
    }

    public void setServerString(String serverString) {
        this.mServerString = serverString;
    }

    public String getServerString() {
        return this.mServerString;
    }

    public void setServerName(String serverName) {
        this.mServerName = serverName;
    }

    public String getServerName() {
        return this.mServerName;
    }

    public Throwable getThrowable() {
        if (this.getTransientThrowable() != null) {
            return this.getTransientThrowable();
        }
        if (this.getWrapper() == null) {
            return null;
        }
        if (this.getWrapper().getRaw() != null) {
            return (Throwable)this.getWrapper().getRaw();
        }
        return new RemoteProxyException(this.getServerMessage(), this.getTraceCapture(), this.getServerString(), this.getServerName());
    }

    public int hashCode() {
        return ArrayUtils.hashCode((Object)this.getTraceCapture()) + ObjectUtils.hashCode((Object)this.getServerMessage()) + ObjectUtils.hashCode((Object)this.getServerString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        RemoteProperties o = (RemoteProperties)other;
        return ArrayUtils.isEquals((Object)this.getTraceCapture(), (Object)o.getTraceCapture()) && ObjectUtils.equals((Object)this.getServerMessage(), (Object)o.getServerMessage()) && ObjectUtils.equals((Object)this.getServerString(), (Object)o.getServerString());
    }
}

