/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.test.TestCaseBase;

public class CloseableRegistryTest
extends TestCaseBase {
    @Before
    public void setupCloseableRegistryTest() {
        OrderedCloseable.resetStaticSequence();
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
    }

    @Test
    public void orderedClosing() {
        CloseableRegistry r = new CloseableRegistry();
        OrderedCloseable t1 = new OrderedCloseable();
        r.register((Closeable)t1);
        OrderedCloseable t2 = new OrderedCloseable();
        r.register((Closeable)t2);
        r.close();
        Assert.assertEquals((long)1L, (long)t2.getSequence());
        Assert.assertEquals((long)2L, (long)t1.getSequence());
    }

    @Test
    public void exceptionsIgnored() {
        CloseableRegistry r = new CloseableRegistry();
        OrderedCloseable t1 = new OrderedCloseable();
        r.register((Closeable)t1);
        r.register((Closeable)new ThrowingCloseable());
        OrderedCloseable t2 = new OrderedCloseable();
        r.register((Closeable)t2);
        r.register((Closeable)new ThrowingCloseable());
        r.close();
        Assert.assertEquals((long)1L, (long)t2.getSequence());
        Assert.assertEquals((long)2L, (long)t1.getSequence());
    }

    private static final class ThrowingCloseable
    implements Closeable {
        private ThrowingCloseable() {
        }

        @Override
        public void close() throws IOException {
            throw new IOException();
        }
    }

    private static final class OrderedCloseable
    implements Closeable {
        private static int sSequence;
        private int mSequence;

        private OrderedCloseable() {
        }

        static void resetStaticSequence() {
            sSequence = 0;
        }

        int getSequence() {
            return this.mSequence;
        }

        @Override
        public void close() {
            this.mSequence = ++sSequence;
        }
    }
}

