/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Writer;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.WrapperTestBase;
import org.marketcetera.util.file.WriterWrapper;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.SignatureCharset;

public class WriterWrapperTest
extends WrapperTestBase {
    @Test
    public void basics() throws Exception {
        CloseCounterWriter counter = new CloseCounterWriter();
        WriterWrapper out = new WriterWrapper((Writer)counter);
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertEquals((long)0L, (long)counter.getFlushes());
        Assert.assertFalse((boolean)out.getSkipClose());
        Assert.assertNotNull((Object)out.getWriter());
        out.close();
        Assert.assertEquals((long)1L, (long)counter.getClosures());
        Assert.assertEquals((long)1L, (long)counter.getFlushes());
        out.close();
        Assert.assertEquals((long)1L, (long)counter.getClosures());
        Assert.assertEquals((long)1L, (long)counter.getFlushes());
        counter = new CloseCounterWriter();
        out = new WriterWrapper((Writer)counter, true);
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertEquals((long)0L, (long)counter.getFlushes());
        Assert.assertTrue((boolean)out.getSkipClose());
        Assert.assertNotNull((Object)out.getWriter());
        out.close();
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertEquals((long)1L, (long)counter.getFlushes());
        out.close();
        Assert.assertEquals((long)0L, (long)counter.getClosures());
        Assert.assertEquals((long)2L, (long)counter.getFlushes());
    }

    @Test(expected=FileNotFoundException.class)
    public void nonexistent() throws Exception {
        WriterWrapper wrapper = new WriterWrapper(TEST_NONEXISTENT_FILE);
        wrapper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testStandardStream(String name, ByteArrayOutputStream out) throws Exception {
        try (CloseableRegistry r = new CloseableRegistry();){
            WriterWrapper wrapper = new WriterWrapper(name);
            r.register((Closeable)wrapper);
            Assert.assertTrue((boolean)wrapper.getSkipClose());
            Assert.assertNotNull((Object)wrapper.getWriter());
            wrapper.getWriter().write("Hello");
        }
        Assert.assertArrayEquals((byte[])VALUE_BYTES, (byte[])out.toByteArray());
    }

    @Override
    protected void testStandardOutputStream(ByteArrayOutputStream out) throws Exception {
        WriterWrapperTest.testStandardStream(":stdout:", out);
    }

    @Override
    protected void testStandardErrorStream(ByteArrayOutputStream err) throws Exception {
        WriterWrapperTest.testStandardStream(":stderr:", err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStandardOutputStreamUnicode() throws Exception {
        PrintStream stdOutSave = System.out;
        CloseableRegistry r = new CloseableRegistry();
        ByteArrayOutputStream stdOutByteArray = new ByteArrayOutputStream();
        try {
            r.register((Closeable)stdOutByteArray);
            PrintStream stdOut = new PrintStream(stdOutByteArray);
            r.register((Closeable)stdOut);
            System.setOut(stdOut);
            WriterWrapper wrapper = new WriterWrapper(":stdout:", SignatureCharset.UTF8_UTF8);
            r.register((Closeable)wrapper);
            Assert.assertTrue((boolean)wrapper.getSkipClose());
            Assert.assertNotNull((Object)wrapper.getWriter());
            wrapper.getWriter().write("Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        }
        finally {
            System.setOut(stdOutSave);
            r.close();
        }
        Assert.assertArrayEquals((byte[])ArrayUtils.addAll((byte[])Signature.UTF8.getMark(), (byte[])UnicodeData.COMBO_UTF8), (byte[])stdOutByteArray.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStandardErrorStreamUnicode() throws Exception {
        PrintStream stdErrSave = System.err;
        CloseableRegistry r = new CloseableRegistry();
        ByteArrayOutputStream stdErrByteArray = new ByteArrayOutputStream();
        try {
            r.register((Closeable)stdErrByteArray);
            PrintStream stdErr = new PrintStream(stdErrByteArray);
            r.register((Closeable)stdErr);
            System.setErr(stdErr);
            WriterWrapper wrapper = new WriterWrapper(":stderr:", SignatureCharset.UTF8_UTF8);
            r.register((Closeable)wrapper);
            Assert.assertTrue((boolean)wrapper.getSkipClose());
            Assert.assertNotNull((Object)wrapper.getWriter());
            wrapper.getWriter().write("Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        }
        finally {
            System.setErr(stdErrSave);
            r.close();
        }
        Assert.assertArrayEquals((byte[])ArrayUtils.addAll((byte[])Signature.UTF8.getMark(), (byte[])UnicodeData.COMBO_UTF8), (byte[])stdErrByteArray.toByteArray());
    }

    @Test
    public void wrappers() throws Exception {
        this.testStandardOutputStream();
        this.testStandardOutputStreamUnicode();
        this.testStandardErrorStream();
        this.testStandardErrorStreamUnicode();
    }

    private static final class CloseCounterWriter
    extends Writer {
        private int mClosures = 0;
        private int mFlushes = 0;

        private CloseCounterWriter() {
        }

        int getClosures() {
            return this.mClosures;
        }

        int getFlushes() {
            return this.mFlushes;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
        }

        @Override
        public void flush() {
            ++this.mFlushes;
        }

        @Override
        public void close() {
            ++this.mClosures;
        }
    }
}

