/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NInterruptedRuntimeException;
import org.marketcetera.util.misc.ReflectUtils;
import org.marketcetera.util.test.CollectionAssert;
import org.marketcetera.util.test.TestCaseBase;

public class ReflectUtilsTest
extends TestCaseBase {
    private static final String OBJECT_NAME = Object.class.getName();
    private static final String EMPTY_NAME = Empty.class.getName();
    private static final String SIMPLE_NAME = Simple.class.getName();
    private static final String DERIVED_NAME = Derived.class.getName();
    private static final String IFACE_NAME = IFace.class.getName();
    private static final String COMPLEX_BASE_NAME = ComplexBase.class.getName();
    private static final String COMPLEX_DERIVED_NAME = ComplexDerived.class.getName();
    private static final String SIMPLE_FIELD = "mSimple";
    private static final String DERIVED_FIELD = "mDerived";
    private static final String IFACE_FIELD = "mIFace";
    private static final String COMPLEX_BASE_FIELD = "mComplexBase";
    private static final String COMPLEX_DERIVED_FIELD = "mComplexDerived";

    private static void assertNamesMatch(String[] expectedNames, Field[] fields) {
        Object[] actualNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            actualNames[i] = fields[i].getName();
        }
        CollectionAssert.assertArrayPermutation((Object[])expectedNames, (Object[])actualNames);
    }

    private static void assertNamesMatch(String[] expectedNames, Class<?>[] classes) {
        Object[] actualNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            actualNames[i] = classes[i].getName();
        }
        CollectionAssert.assertArrayPermutation((Object[])expectedNames, (Object[])actualNames);
    }

    @Test
    public void classes() {
        ReflectUtilsTest.assertNamesMatch(new String[]{OBJECT_NAME, EMPTY_NAME}, ReflectUtils.getAllClasses(Empty.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{OBJECT_NAME, SIMPLE_NAME}, ReflectUtils.getAllClasses(Simple.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{OBJECT_NAME, SIMPLE_NAME, DERIVED_NAME}, ReflectUtils.getAllClasses(Derived.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{IFACE_NAME}, ReflectUtils.getAllClasses(IFace.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{OBJECT_NAME, SIMPLE_NAME, IFACE_NAME, COMPLEX_BASE_NAME}, ReflectUtils.getAllClasses(ComplexBase.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{OBJECT_NAME, SIMPLE_NAME, IFACE_NAME, COMPLEX_BASE_NAME, COMPLEX_DERIVED_NAME}, ReflectUtils.getAllClasses(ComplexDerived.class));
    }

    @Test
    public void fields() {
        ReflectUtilsTest.assertNamesMatch(ArrayUtils.EMPTY_STRING_ARRAY, ReflectUtils.getAllFields(Empty.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{SIMPLE_FIELD}, ReflectUtils.getAllFields(Simple.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{SIMPLE_FIELD, DERIVED_FIELD}, ReflectUtils.getAllFields(Derived.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{IFACE_FIELD}, ReflectUtils.getAllFields(IFace.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{SIMPLE_FIELD, IFACE_FIELD, COMPLEX_BASE_FIELD}, ReflectUtils.getAllFields(ComplexBase.class));
        ReflectUtilsTest.assertNamesMatch(new String[]{SIMPLE_FIELD, IFACE_FIELD, COMPLEX_BASE_FIELD, COMPLEX_DERIVED_FIELD}, ReflectUtils.getAllFields(ComplexDerived.class));
    }

    @Test
    public void instance() throws Exception {
        Assert.assertEquals((long)1L, (long)((IntObject)ReflectUtils.getInstance((String)IntObject.class.getName(), (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{new Integer(1)})).getValue());
        try {
            ReflectUtils.getInstance((String)"NonExistent", null, null);
            Assert.fail();
        }
        catch (ClassNotFoundException ex) {
            Assert.assertFalse((boolean)Thread.interrupted());
        }
        try {
            ReflectUtils.getInstance((String)IntObject.class.getName(), (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{new Integer(0)});
            Assert.fail();
        }
        catch (InvocationTargetException ex) {
            Assert.assertTrue((boolean)Thread.interrupted());
            Assert.assertEquals(I18NInterruptedRuntimeException.class, ex.getCause().getClass());
        }
    }

    private static class IntObject {
        private int mValue;

        public IntObject(int value) {
            if (value == 0) {
                throw new I18NInterruptedRuntimeException();
            }
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    private static class ComplexDerived
    extends ComplexBase
    implements IFace {
        int mComplexDerived;

        private ComplexDerived() {
        }
    }

    private static class ComplexBase
    extends Simple
    implements IFace {
        int mComplexBase;

        private ComplexBase() {
        }
    }

    private static interface IFace {
        public static final int mIFace = 0;
    }

    private static class Derived
    extends Simple {
        int mDerived;

        private Derived() {
        }
    }

    private static class Simple {
        int mSimple;

        private Simple() {
        }
    }

    private static class Empty {
        private Empty() {
        }
    }
}

