/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.misc.UCPFilter;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.unicode.UnicodeCharset;

public class UCPFilterTest
extends TestCaseBase {
    @Test
    public void all() {
        Assert.assertTrue((boolean)UCPFilter.VALID.isAcceptable(32));
        Assert.assertFalse((boolean)UCPFilter.VALID.isAcceptable(55296));
        Assert.assertTrue((boolean)UCPFilter.CHAR.isAcceptable(32));
        Assert.assertTrue((boolean)UCPFilter.CHAR.isAcceptable(65535));
        Assert.assertFalse((boolean)UCPFilter.CHAR.isAcceptable(65536));
        Assert.assertTrue((boolean)UCPFilter.DIGIT.isAcceptable(49));
        Assert.assertFalse((boolean)UCPFilter.DIGIT.isAcceptable(97));
        Assert.assertTrue((boolean)UCPFilter.LETTER.isAcceptable(97));
        Assert.assertFalse((boolean)UCPFilter.LETTER.isAcceptable(49));
        Assert.assertTrue((boolean)UCPFilter.ALNUM.isAcceptable(97));
        Assert.assertTrue((boolean)UCPFilter.ALNUM.isAcceptable(49));
        Assert.assertFalse((boolean)UCPFilter.ALNUM.isAcceptable(32));
        UCPFilter dc = UCPFilter.getDefaultCharset();
        Assert.assertSame((Object)dc, (Object)UCPFilter.getDefaultCharset());
        Assert.assertTrue((boolean)dc.isAcceptable(97));
        Assert.assertFalse((boolean)dc.isAcceptable(55296));
        UCPFilter fs = UCPFilter.getFileSystemCharset();
        Assert.assertSame((Object)fs, (Object)UCPFilter.getFileSystemCharset());
        Assert.assertTrue((boolean)fs.isAcceptable(97));
        Assert.assertFalse((boolean)fs.isAcceptable(55296));
        UCPFilter utf8 = UCPFilter.forCharset((Charset)UnicodeCharset.UTF8.getCharset());
        Assert.assertSame((Object)utf8, (Object)UCPFilter.forCharset((Charset)UnicodeCharset.UTF8.getCharset()));
        Assert.assertTrue((boolean)utf8.isAcceptable(97));
        Assert.assertFalse((boolean)utf8.isAcceptable(55296));
    }
}

