/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.spring;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.spring.LazyBean;
import org.marketcetera.util.spring.Messages;
import org.marketcetera.util.test.TestCaseBase;

public class LazyBeanTest
extends TestCaseBase {
    @Test
    public void correct() {
        Correct c = new Correct();
        c.setRawValue(0);
        c.setRawValue(1);
        Assert.assertEquals((long)2L, (long)c.getCompValue());
        try {
            c.setRawValue(2);
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            Assert.assertEquals((Object)((Object)new I18NRuntimeException((I18NBoundMessage)Messages.LAZY_ALREADY_PROCESSED)), (Object)((Object)ex));
        }
    }

    @Test
    public void recursive() {
        Recursive r = new Recursive();
        r.setRawValue(0);
        try {
            r.getCompValue();
            Assert.fail();
        }
        catch (I18NRuntimeException ex) {
            Assert.assertEquals((Object)((Object)new I18NRuntimeException((I18NBoundMessage)Messages.LAZY_IN_PROCESS)), (Object)((Object)ex));
        }
        r.setRawValue(1);
        Assert.assertEquals((long)2L, (long)r.getCompValue());
    }

    private static class Recursive
    extends Correct {
        private Recursive() {
        }

        @Override
        protected void process() {
            if (this.getRawValue() == 0) {
                this.getCompValue();
            }
            super.process();
        }
    }

    private static class Correct
    extends LazyBean {
        private int mRawValue;
        private int mCompValue;

        private Correct() {
        }

        public void setRawValue(int rawValue) {
            this.assertNotProcessed();
            this.mRawValue = rawValue;
        }

        public int getRawValue() {
            return this.mRawValue;
        }

        private void setCompValue(int compValue) {
            this.mCompValue = compValue;
        }

        public int getCompValue() {
            this.ensureProcessed();
            return this.mCompValue;
        }

        protected void process() {
            this.setCompValue(this.getRawValue() + 1);
        }
    }
}

