/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import org.junit.Assert;
import org.junit.Ignore;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.InputStreamWrapper;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.IOTestBase;
import org.marketcetera.util.unicode.SignatureCharset;
import org.marketcetera.util.unicode.UnicodeInputStreamReader;

@Ignore
public abstract class EncoderTestBase
extends IOTestBase {
    protected abstract byte[] encode(String var1) throws Exception;

    protected void testEncode(byte[] bytes, String string) throws Exception {
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(string));
    }

    protected abstract byte[] encode(SignatureCharset var1, String var2) throws Exception;

    protected void testEncode(SignatureCharset sc, byte[] bytes, String string) throws Exception {
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(sc, string));
    }

    protected abstract byte[] encode(Reader var1, SignatureCharset var2, String var3) throws Exception;

    protected void testEncode(Reader reader, SignatureCharset sc, byte[] bytes, String string) throws Exception {
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.encode(reader, sc, string));
    }

    @Override
    protected void testNative() throws Exception {
        this.testEncode(UnicodeData.HELLO_EN_NAT, "Hello");
        this.testEncode(null, UnicodeData.HELLO_EN_NAT, "Hello");
        this.testEncode(null, null, UnicodeData.HELLO_EN_NAT, "Hello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void testSignatureCharset(SignatureCharset sc, byte[] bytes) throws Exception {
        this.testEncode(sc, bytes, "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        try (CloseableRegistry r = new CloseableRegistry();){
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            r.register((Closeable)new InputStreamWrapper((InputStream)is));
            UnicodeInputStreamReader reader = new UnicodeInputStreamReader((InputStream)is, sc);
            r.register((Closeable)new ReaderWrapper((Reader)reader));
            this.testEncode((Reader)reader, sc, bytes, "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        }
    }

    @Override
    protected void testStrategy(DecodingStrategy strategy, SignatureCharset sc, String string, byte[] bytes) throws Exception {
    }
}

