/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.wrappers;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.MarshalException;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.wrappers.BaseWrapper;
import org.marketcetera.util.ws.wrappers.RootElementWrapper;

public class RootElementWrapperTest
extends TestCaseBase {
    @Test
    public void basics() throws Exception {
        Object o = new Object();
        EqualityAssert.assertEquality((Object)new RootElementWrapper(o), (Object)new RootElementWrapper(o), (Object[])new Object[]{new RootElementWrapper(new Object())});
        RootElementWrapper w = new RootElementWrapper(o);
        Assert.assertSame((Object)o, (Object)w.getObject());
        Object o2 = new Object();
        w.setObject(o2);
        Assert.assertSame((Object)o2, (Object)w.getObject());
        w.setObject(null);
        Assert.assertNull((Object)w.getObject());
    }

    @Test
    public void marshalling() throws Exception {
        MyInteger value = new MyInteger(1);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MyInteger.class});
        StringWriter writer = new StringWriter();
        try {
            context.createMarshaller().marshal((Object)value, (Writer)writer);
            Assert.fail();
        }
        catch (MarshalException marshalException) {
            // empty catch block
        }
        RootElementWrapper w = new RootElementWrapper((Object)value);
        context = JAXBContext.newInstance((Class[])new Class[]{RootElementWrapper.class, MyInteger.class});
        writer = new StringWriter();
        context.createMarshaller().marshal((Object)w, (Writer)writer);
        Assert.assertEquals((Object)w, (Object)context.createUnmarshaller().unmarshal((Reader)new StringReader(writer.toString())));
    }

    private static class MyInteger
    extends BaseWrapper<Integer> {
        public MyInteger(int value) {
            super((Object)value);
        }

        private MyInteger() {
        }

        public void setInt(int value) {
            this.setValue(value);
        }

        public int getInt() {
            return (Integer)this.getValue();
        }
    }
}

