/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.except;

import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileLockInterruptionException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.naming.InterruptedNamingException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.except.I18NInterruptedException;
import org.marketcetera.util.except.I18NInterruptedRuntimeException;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.except.I18NThrowable;
import org.marketcetera.util.except.Messages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ExceptUtils.java 16914 2014-06-24 21:27:56Z colin $")
public final class ExceptUtils {
    public static void checkInterruption() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException(Messages.THREAD_INTERRUPTED.getText());
        }
    }

    public static void checkInterruption(String message) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException(message);
        }
    }

    public static void checkInterruption(Throwable cause) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            InterruptedException ex = new InterruptedException(Messages.THREAD_INTERRUPTED.getText());
            ex.initCause(cause);
            throw ex;
        }
    }

    public static void checkInterruption(Throwable cause, String message) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            InterruptedException ex = new InterruptedException(message);
            ex.initCause(cause);
            throw ex;
        }
    }

    public static boolean isInterruptException(Throwable throwable) {
        return throwable instanceof InterruptedException || throwable instanceof InterruptedIOException || throwable instanceof ClosedByInterruptException || throwable instanceof FileLockInterruptionException || throwable instanceof InterruptedNamingException || throwable instanceof I18NInterruptedException || throwable instanceof I18NInterruptedRuntimeException;
    }

    public static boolean interrupt(Throwable throwable) {
        if (ExceptUtils.isInterruptException(throwable)) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public static boolean swallow(Throwable throwable, Object category, I18NBoundMessage message) {
        message.warn(category, throwable);
        return ExceptUtils.interrupt(throwable);
    }

    public static boolean swallow(Throwable throwable) {
        return ExceptUtils.swallow(throwable, ExceptUtils.class, Messages.THROWABLE_IGNORED);
    }

    public static I18NException wrap(Throwable throwable, I18NBoundMessage message) {
        if (ExceptUtils.isInterruptException(throwable)) {
            Thread.currentThread().interrupt();
            return new I18NInterruptedException(throwable, message);
        }
        return new I18NException(throwable, message);
    }

    public static I18NException wrap(Throwable throwable) {
        if (ExceptUtils.isInterruptException(throwable)) {
            Thread.currentThread().interrupt();
            return new I18NInterruptedException(throwable);
        }
        return new I18NException(throwable);
    }

    public static I18NRuntimeException wrapRuntime(Throwable throwable, I18NBoundMessage message) {
        if (ExceptUtils.isInterruptException(throwable)) {
            Thread.currentThread().interrupt();
            return new I18NInterruptedRuntimeException(throwable, message);
        }
        return new I18NRuntimeException(throwable, message);
    }

    public static I18NRuntimeException wrapRuntime(Throwable throwable) {
        if (ExceptUtils.isInterruptException(throwable)) {
            Thread.currentThread().interrupt();
            return new I18NInterruptedRuntimeException(throwable);
        }
        return new I18NRuntimeException(throwable);
    }

    public static int getHashCode(Throwable t) {
        if (t == null) {
            return 0;
        }
        int code = ObjectUtils.hashCode(t.getClass());
        code = t instanceof I18NThrowable ? (code += ObjectUtils.hashCode((Object)((I18NThrowable)((Object)t)).getI18NBoundMessage())) : (code += ObjectUtils.hashCode((Object)t.getMessage()));
        return code += ExceptUtils.getHashCode(t.getCause());
    }

    public static boolean areEqual(Throwable t, Object o) {
        if (t == o) {
            return true;
        }
        if (o == null || t == null || !t.getClass().equals(o.getClass())) {
            return false;
        }
        Throwable to = (Throwable)o;
        if (o instanceof I18NThrowable ? !ObjectUtils.equals((Object)((I18NThrowable)((Object)t)).getI18NBoundMessage(), (Object)((I18NThrowable)o).getI18NBoundMessage()) : !ObjectUtils.equals((Object)t.getMessage(), (Object)to.getMessage())) {
            return false;
        }
        return ExceptUtils.areEqual(t.getCause(), to.getCause());
    }

    public static String getRootCauseMessage(Throwable inException) {
        LinkedList causes = new LinkedList(ExceptionUtils.getThrowableList((Throwable)inException));
        Iterator causeIterator = causes.descendingIterator();
        while (causeIterator.hasNext()) {
            Throwable cause = (Throwable)causeIterator.next();
            if (cause.getMessage() == null) continue;
            return cause.getMessage();
        }
        return ExceptionUtils.getRootCauseMessage((Throwable)inException);
    }

    private ExceptUtils() {
    }
}

