/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.InputStreamWrapper;
import org.marketcetera.util.file.Messages;
import org.marketcetera.util.file.OutputStreamWrapper;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: CopyBytesUtils.java 16154 2012-07-14 16:34:05Z colin $")
public final class CopyBytesUtils {
    public static long copy(InputStream in, boolean inSkipClose, OutputStream out, boolean outSkipClose) throws I18NException {
        try (CloseableRegistry registry = new CloseableRegistry();){
            InputStreamWrapper inW = new InputStreamWrapper(in, inSkipClose);
            registry.register(inW);
            OutputStreamWrapper outW = new OutputStreamWrapper(out, outSkipClose);
            registry.register(outW);
            long l = IOUtils.copyLarge((InputStream)inW.getStream(), (OutputStream)outW.getStream());
            return l;
        }
    }

    public static long copy(String in, String out) throws I18NException {
        try (CloseableRegistry registry = new CloseableRegistry();){
            InputStreamWrapper inW = new InputStreamWrapper(in);
            registry.register(inW);
            OutputStreamWrapper outW = new OutputStreamWrapper(out);
            registry.register(outW);
            long l = IOUtils.copyLarge((InputStream)inW.getStream(), (OutputStream)outW.getStream());
            return l;
        }
    }

    public static long copy(InputStream in, boolean skipClose, String out) throws I18NException {
        try (CloseableRegistry registry = new CloseableRegistry();){
            InputStreamWrapper inW = new InputStreamWrapper(in, skipClose);
            registry.register(inW);
            OutputStreamWrapper outW = new OutputStreamWrapper(out);
            registry.register(outW);
            long l = IOUtils.copyLarge((InputStream)inW.getStream(), (OutputStream)outW.getStream());
            return l;
        }
    }

    public static long copy(String in, OutputStream out, boolean skipClose) throws I18NException {
        try (CloseableRegistry registry = new CloseableRegistry();){
            InputStreamWrapper inW = new InputStreamWrapper(in);
            registry.register(inW);
            OutputStreamWrapper outW = new OutputStreamWrapper(out, skipClose);
            registry.register(outW);
            long l = IOUtils.copyLarge((InputStream)inW.getStream(), (OutputStream)outW.getStream());
            return l;
        }
    }

    public static byte[] copy(String name) throws I18NException {
        byte[] byArray;
        InputStreamWrapper inW = new InputStreamWrapper(name);
        try {
            byArray = IOUtils.toByteArray((InputStream)inW.getStream());
        }
        catch (Throwable throwable) {
            try {
                inW.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw ExceptUtils.wrap(ex, new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_DST, (Serializable)((Object)name)));
            }
        }
        inW.close();
        return byArray;
    }

    public static void copy(byte[] data, String name) throws I18NException {
        try (OutputStreamWrapper outW = new OutputStreamWrapper(name);){
            outW.getStream().write(data);
        }
        catch (IOException ex) {
            throw ExceptUtils.wrap(ex, new I18NBoundMessage1P(Messages.CANNOT_COPY_MEMORY_SRC, (Serializable)((Object)name)));
        }
    }

    private CopyBytesUtils() {
    }
}

