/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.UnicodeFileReader;
import org.marketcetera.util.unicode.UnicodeInputStreamReader;

@ClassVersion(value="$Id: ReaderWrapper.java 16154 2012-07-14 16:34:05Z colin $")
public class ReaderWrapper
implements Closeable {
    private Reader mReader;
    private boolean mSkipClose;

    public ReaderWrapper(String name, DecodingStrategy decodingStrategy) throws FileNotFoundException {
        if (name.equals(":stdin:")) {
            this.mReader = new UnicodeInputStreamReader(System.in, decodingStrategy);
            this.mSkipClose = true;
            return;
        }
        this.mReader = new UnicodeFileReader(name, decodingStrategy);
    }

    public ReaderWrapper(String name) throws FileNotFoundException {
        this(name, null);
    }

    public ReaderWrapper(File file, DecodingStrategy decodingStrategy) throws FileNotFoundException {
        this.mReader = new UnicodeFileReader(file, decodingStrategy);
    }

    public ReaderWrapper(File file) throws FileNotFoundException {
        this(file, null);
    }

    public ReaderWrapper(Reader reader, boolean skipClose) {
        this.mReader = reader;
        this.mSkipClose = skipClose;
    }

    public ReaderWrapper(Reader reader) {
        this(reader, false);
    }

    @Override
    public void close() throws IOException {
        if (this.getReader() == null || this.getSkipClose()) {
            return;
        }
        this.getReader().close();
        this.mReader = null;
    }

    public Reader getReader() {
        return this.mReader;
    }

    public boolean getSkipClose() {
        return this.mSkipClose;
    }
}

