/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.l10n;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.SystemUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.l10n.ContainerClassInfo;
import org.marketcetera.util.l10n.MessageInfo;
import org.marketcetera.util.l10n.MessageInfoPair;
import org.marketcetera.util.l10n.MessageInfoProvider;
import org.marketcetera.util.l10n.Messages;
import org.marketcetera.util.l10n.PropertiesFileInfo;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: MessageComparator.java 16154 2012-07-14 16:34:05Z colin $")
public class MessageComparator {
    private MessageInfoPair[] mMismatches;
    private MessageInfo[] mExtraSrcInfo;
    private MessageInfo[] mExtraDstInfo;

    public MessageComparator(List<MessageInfo> srcInfo, List<MessageInfo> dstInfo) {
        HashMap<String, MessageInfo> srcMessages = this.toHashMap(srcInfo);
        HashMap<String, MessageInfo> dstMessages = this.toHashMap(dstInfo);
        LinkedList<MessageInfoPair> mismatches = new LinkedList<MessageInfoPair>();
        LinkedList<MessageInfo> extraSrcInfo = new LinkedList<MessageInfo>();
        for (String name : srcMessages.keySet()) {
            MessageInfo srcMessage = srcMessages.get(name);
            if (!dstMessages.containsKey(name)) {
                extraSrcInfo.add(srcMessage);
                continue;
            }
            MessageInfo dstMessage = dstMessages.get(name);
            if (srcMessage.getParamCount() != -1 && dstMessage.getParamCount() != -1 && srcMessage.getParamCount() != dstMessage.getParamCount()) {
                mismatches.add(new MessageInfoPair(srcMessage, dstMessage));
            }
            dstMessages.remove(name);
        }
        this.mMismatches = mismatches.toArray(MessageInfoPair.EMPTY_ARRAY);
        this.mExtraSrcInfo = extraSrcInfo.toArray(MessageInfo.EMPTY_ARRAY);
        this.mExtraDstInfo = dstMessages.values().toArray(MessageInfo.EMPTY_ARRAY);
    }

    public MessageComparator(MessageInfoProvider srcProvider, MessageInfoProvider dstProvider) {
        this(srcProvider.getMessageInfo(), dstProvider.getMessageInfo());
    }

    private MessageComparator(ContainerClassInfo classInfo, Locale locale) throws I18NException {
        this((MessageInfoProvider)classInfo, new PropertiesFileInfo(classInfo.getProvider(), locale));
    }

    public MessageComparator(ContainerClassInfo classInfo) throws I18NException {
        this(classInfo, Locale.ROOT);
    }

    public MessageComparator(Class<?> container, Locale locale) throws I18NException {
        this(new ContainerClassInfo(container), locale);
    }

    public MessageComparator(Class<?> container) throws I18NException {
        this(new ContainerClassInfo(container));
    }

    private HashMap<String, MessageInfo> toHashMap(List<MessageInfo> infoList) {
        HashMap<String, MessageInfo> result = new HashMap<String, MessageInfo>();
        for (MessageInfo info : infoList) {
            result.put(info.getKey(), info);
        }
        return result;
    }

    public MessageInfoPair[] getMismatches() {
        return this.mMismatches;
    }

    public MessageInfo[] getExtraSrcInfo() {
        return this.mExtraSrcInfo;
    }

    public MessageInfo[] getExtraDstInfo() {
        return this.mExtraDstInfo;
    }

    public boolean isMatch() {
        return this.getMismatches().length == 0 && this.getExtraSrcInfo().length == 0 && this.getExtraDstInfo().length == 0;
    }

    public String getDifferences() {
        StringBuilder builder = new StringBuilder();
        for (MessageInfoPair messageInfoPair : this.getMismatches()) {
            if (builder.length() > 0) {
                builder.append(SystemUtils.LINE_SEPARATOR);
            }
            builder.append(Messages.PARAM_COUNT_MISMATCH.getText(messageInfoPair.getSrcInfo().getKey(), messageInfoPair.getSrcInfo().getParamCount(), messageInfoPair.getDstInfo().getParamCount()));
        }
        for (MessageInfo messageInfo : this.getExtraSrcInfo()) {
            if (builder.length() > 0) {
                builder.append(SystemUtils.LINE_SEPARATOR);
            }
            builder.append(Messages.EXTRA_SRC_MESSAGE.getText(messageInfo.getKey()));
        }
        for (MessageInfo messageInfo : this.getExtraDstInfo()) {
            if (builder.length() > 0) {
                builder.append(SystemUtils.LINE_SEPARATOR);
            }
            builder.append(Messages.EXTRA_DST_MESSAGE.getText(messageInfo.getKey()));
        }
        return builder.toString();
    }
}

