/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.l10n;

import java.util.Properties;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: MessageInfo.java 16154 2012-07-14 16:34:05Z colin $")
public abstract class MessageInfo {
    public static final MessageInfo[] EMPTY_ARRAY = new MessageInfo[0];
    private String mKey;
    private int mParamCount;

    public MessageInfo(String key, int paramCount) {
        this.mKey = key;
        this.mParamCount = paramCount;
    }

    public static Properties getList(MessageInfo[] info) {
        Properties properties = new Properties();
        for (MessageInfo m : info) {
            StringBuilder builder = new StringBuilder();
            builder.append(m.getKey());
            builder.append(' ');
            for (int i = 0; i < m.getParamCount(); ++i) {
                builder.append('{');
                builder.append(i);
                builder.append('}');
            }
            properties.put(m.getKey(), builder.toString());
        }
        return properties;
    }

    public String getKey() {
        return this.mKey;
    }

    public int getParamCount() {
        return this.mParamCount;
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.getKey()) + this.getParamCount();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        MessageInfo o = (MessageInfo)other;
        return ObjectUtils.equals((Object)this.getKey(), (Object)o.getKey()) && this.getParamCount() == o.getParamCount();
    }
}

