/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NLoggerProxy;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: I18NBoundMessageBase.java 16154 2012-07-14 16:34:05Z colin $")
public class I18NBoundMessageBase<T extends I18NMessage>
implements I18NBoundMessage {
    private static final long serialVersionUID = 1L;
    private static final String SELF_PROXY = I18NBoundMessageBase.class.getName();
    private T mMessage;
    private Serializable[] mParams;

    I18NBoundMessageBase(T message, Serializable ... params) {
        this.mMessage = message;
        this.mParams = params == null || params.length == 0 ? EMPTY_PARAMS : params;
    }

    @Override
    public I18NLoggerProxy getLoggerProxy() {
        return ((I18NMessage)this.getMessage()).getLoggerProxy();
    }

    @Override
    public I18NMessageProvider getMessageProvider() {
        return ((I18NMessage)this.getMessage()).getMessageProvider();
    }

    public T getMessage() {
        return this.mMessage;
    }

    @Override
    public Serializable[] getParams() {
        return this.mParams;
    }

    @Override
    public Object[] getParamsAsObjects() {
        return this.getParams();
    }

    @Override
    public String getText(Locale locale) {
        return this.getMessageProvider().getText(locale, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public String getText() {
        return this.getMessageProvider().getText((I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void error(Object category, Throwable throwable) {
        this.getLoggerProxy().errorProxy(SELF_PROXY, category, throwable, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void error(Object category) {
        this.getLoggerProxy().errorProxy(SELF_PROXY, category, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void warn(Object category, Throwable throwable) {
        this.getLoggerProxy().warnProxy(SELF_PROXY, category, throwable, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void warn(Object category) {
        this.getLoggerProxy().warnProxy(SELF_PROXY, category, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void info(Object category, Throwable throwable) {
        this.getLoggerProxy().infoProxy(SELF_PROXY, category, throwable, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void info(Object category) {
        this.getLoggerProxy().infoProxy(SELF_PROXY, category, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void debug(Object category, Throwable throwable) {
        this.getLoggerProxy().debugProxy(SELF_PROXY, category, throwable, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void debug(Object category) {
        this.getLoggerProxy().debugProxy(SELF_PROXY, category, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void trace(Object category, Throwable throwable) {
        this.getLoggerProxy().traceProxy(SELF_PROXY, category, throwable, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    @Override
    public void trace(Object category) {
        this.getLoggerProxy().traceProxy(SELF_PROXY, category, (I18NMessage)this.getMessage(), this.getParamsAsObjects());
    }

    public String toString() {
        return this.getText();
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.getMessage()) + ArrayUtils.hashCode((Object)this.getParams());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        I18NBoundMessageBase o = (I18NBoundMessageBase)other;
        return ObjectUtils.equals(this.getMessage(), o.getMessage()) && ArrayUtils.isEquals((Object)this.getParams(), (Object)o.getParams());
    }
}

