/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.quickfix;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.quickfix.Messages;
import org.marketcetera.util.quickfix.SpringSessionSettings;
import org.marketcetera.util.spring.LazyBean;
import quickfix.Dictionary;
import quickfix.SessionID;

@ClassVersion(value="$Id: SpringSessionDescriptor.java 17411 2017-04-28 14:50:38Z colin $")
public class SpringSessionDescriptor
extends LazyBean {
    public static final String DEFAULT_DATA_DICTIONARY = "metc.DefaultDataDictionary";
    private static final Map<String, String> DATA_DICTIONARY_MAP = new HashMap<String, String>();
    private Map<String, String> mDictionary;
    private SpringSessionSettings mSettings;
    private Dictionary mQDictionary;
    private SessionID mQSessionID;

    public void setDictionary(Map<String, String> dictionary) {
        this.assertNotProcessed();
        this.mDictionary = dictionary;
    }

    public Map<String, String> getDictionary() {
        return this.mDictionary;
    }

    public void setSettings(SpringSessionSettings settings) {
        this.assertNotProcessed();
        this.mSettings = settings;
    }

    public SpringSessionSettings getSettings() {
        return this.mSettings;
    }

    public Dictionary getQDictionary() {
        this.ensureProcessed();
        return this.mQDictionary;
    }

    public SessionID getQSessionID() {
        this.ensureProcessed();
        return this.mQSessionID;
    }

    private String getKeyValue(String key) {
        if (this.getDictionary() != null && this.getDictionary().containsKey(key)) {
            return this.getDictionary().get(key);
        }
        if (this.getSettings() != null && this.getSettings().getDefaults() != null && this.getSettings().getDefaults().containsKey(key)) {
            return (String)this.getSettings().getDefaults().get(key);
        }
        return null;
    }

    private void assertValueSet(String key, String value) throws I18NRuntimeException {
        if (value == null) {
            throw new I18NRuntimeException(new I18NBoundMessage1P(Messages.FIELD_REQUIRED, (Serializable)((Object)key)));
        }
    }

    @Override
    protected void process() {
        if (this.getSettings() == null) {
            Messages.MISSING_SETTINGS.debug(this);
        }
        String beginString = this.getKeyValue("BeginString");
        this.assertValueSet("BeginString", beginString);
        String senderCompID = this.getKeyValue("SenderCompID");
        this.assertValueSet("SenderCompID", senderCompID);
        String targetCompID = this.getKeyValue("TargetCompID");
        this.assertValueSet("TargetCompID", targetCompID);
        this.mQDictionary = new Dictionary();
        if (this.getDictionary() != null) {
            for (Map.Entry<String, String> entry : this.getDictionary().entrySet()) {
                this.mQDictionary.setString(entry.getKey(), entry.getValue());
            }
        }
        this.mQSessionID = new SessionID(beginString, senderCompID, this.getKeyValue("SenderSubID"), this.getKeyValue("SenderLocationID"), targetCompID, this.getKeyValue("TargetSubID"), this.getKeyValue("TargetLocationID"), this.getKeyValue("SessionQualifier"));
        String dataDictionary = this.getKeyValue("DataDictionary");
        if (DEFAULT_DATA_DICTIONARY.equals(dataDictionary)) {
            if (!DATA_DICTIONARY_MAP.containsKey(beginString)) {
                throw new I18NRuntimeException(new I18NBoundMessage1P(Messages.NO_DEFAULT_DATA_DICTIONARY, (Serializable)((Object)beginString)));
            }
            this.mQDictionary.setString("DataDictionary", DATA_DICTIONARY_MAP.get(beginString));
        }
    }

    static {
        DATA_DICTIONARY_MAP.put("FIX.4.0", "FIX40.xml");
        DATA_DICTIONARY_MAP.put("FIX.4.1", "FIX41.xml");
        DATA_DICTIONARY_MAP.put("FIX.4.2", "FIX42.xml");
        DATA_DICTIONARY_MAP.put("FIX.4.3", "FIX43.xml");
        DATA_DICTIONARY_MAP.put("FIX.4.4", "FIX44.xml");
        DATA_DICTIONARY_MAP.put("FIXT.1.1", "FIXT11.xml");
        DATA_DICTIONARY_MAP.put("FIX.5.0", "FIX50.xml");
        DATA_DICTIONARY_MAP.put("FIX.5.0SP1", "FIX50SP1.xml");
        DATA_DICTIONARY_MAP.put("FIX.5.0SP2", "FIX50SP2.xml");
    }
}

