/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public abstract class DateService {
    public static final ZoneId zoneUTC = ZoneId.of("UTC");

    public static LocalDateTime toLocalDateTime(Date inDate) {
        return LocalDateTime.ofInstant(inDate.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime toUtcDateTime(Date inDate) {
        return LocalDateTime.ofInstant(inDate.toInstant(), zoneUTC);
    }

    public static LocalDate toLocalDate(Date inDate) {
        return DateService.toLocalDateTime(inDate).toLocalDate();
    }

    public static LocalDate toUtcDate(Date inDate) {
        return DateService.toUtcDateTime(inDate).toLocalDate();
    }

    public static LocalTime toLocalTime(Date inDate) {
        return DateService.toLocalDateTime(inDate).toLocalTime();
    }

    public static LocalTime toUtcTime(Date inDate) {
        return DateService.toUtcDateTime(inDate).toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(long inMillis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(inMillis), ZoneId.systemDefault());
    }

    public static LocalDateTime toUtcDateTime(long inMillis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(inMillis), zoneUTC);
    }

    public static long toLocalEpochMillis(LocalDateTime inTimestamp) {
        return inTimestamp.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toUtcEpochMillis(LocalDateTime inTimestamp) {
        return inTimestamp.atZone(zoneUTC).toInstant().toEpochMilli();
    }

    public static Date toLocalDate(LocalDateTime inTimestamp) {
        return new Date(DateService.toLocalEpochMillis(inTimestamp));
    }

    public static Date toUtcDate(LocalDateTime inTimestamp) {
        return new Date(DateService.toUtcEpochMillis(inTimestamp));
    }

    public static Date toUtcDate(LocalDate inUtcDate) {
        LocalDateTime localDateTime = LocalDateTime.of(inUtcDate, LocalTime.MIDNIGHT);
        return DateService.toUtcDate(localDateTime);
    }

    public static Date toUtcDate(LocalTime inUtcTime) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.now(), inUtcTime);
        return DateService.toUtcDate(localDateTime);
    }

    public static LocalDateTime toLocalDateTime(Calendar inTimestamp) {
        return DateService.toLocalDateTime(inTimestamp.getTime());
    }
}

