/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import java.util.Arrays;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.AuthService;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.Messages;
import org.marketcetera.util.ws.stateful.RemoteRunner;
import org.marketcetera.util.ws.stateful.ServiceBaseImpl;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessRemoteCaller;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: AuthServiceImpl.java 16154 2012-07-14 16:34:05Z colin $")
public class AuthServiceImpl<T>
extends ServiceBaseImpl<T>
implements AuthService {
    private final Authenticator mAuthenticator;

    public AuthServiceImpl(Authenticator authenticator, SessionManager<T> sessionManager) {
        super(sessionManager);
        this.mAuthenticator = authenticator;
    }

    public Authenticator getAuthenticator() {
        return this.mAuthenticator;
    }

    private SessionId loginImpl(StatelessClientContext context, String user, char[] password) throws I18NException {
        if (!this.getAuthenticator().shouldAllow(context, user, password)) {
            throw new I18NException(Messages.BAD_CREDENTIALS);
        }
        SessionId sessionId = SessionId.generate();
        this.getSessionManager().put(sessionId, new SessionHolder(user, context));
        return sessionId;
    }

    private void logout(ClientContext context, SessionHolder<T> sessionHolder) {
        if (sessionHolder != null) {
            this.getSessionManager().remove(context.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionId login(StatelessClientContext context, final String user, final char[] password) throws RemoteException {
        try {
            SessionId sessionId = (SessionId)new StatelessRemoteCaller<SessionId>(){

                @Override
                protected SessionId call(StatelessClientContext context) throws I18NException {
                    return AuthServiceImpl.this.loginImpl(context, user, password);
                }
            }.execute(context);
            return sessionId;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    @Override
    public void logout(ClientContext context) throws RemoteException {
        new RemoteRunner<T>(RemoteRunner.DEFAULT_VERSION_FILTER, null, null, this.getSessionManager(), null){

            @Override
            protected void run(ClientContext context, SessionHolder<T> sessionHolder) {
                AuthServiceImpl.this.logout(context, sessionHolder);
            }
        }.execute(context);
    }
}

