/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.ContextClassProvider;
import org.marketcetera.util.ws.stateful.AuthService;
import org.marketcetera.util.ws.stateful.AuthServiceImpl;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.ServerProvider;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.ServiceInterface;
import org.marketcetera.util.ws.stateless.StatelessServer;

@ClassVersion(value="$Id: Server.java 17411 2017-04-28 14:50:38Z colin $")
public class Server<SessionClazz>
extends StatelessServer
implements ServerProvider<SessionClazz> {
    private final Authenticator mAuthenticator;
    private final SessionManager<SessionClazz> mSessionManager;
    private final ServiceInterface mAuthService;

    public Server(String host, int port, Authenticator authenticator, SessionManager<SessionClazz> sessionManager) {
        this(host, port, authenticator, sessionManager, null);
    }

    public Server(String inHost, int inPort, Authenticator inAuthenticator, SessionManager<SessionClazz> inSessionManager, ContextClassProvider inContextClassProvider) {
        super(inHost, inPort, inContextClassProvider);
        this.mAuthenticator = inAuthenticator;
        this.mSessionManager = inSessionManager;
        if (this.getSessionManager() != null) {
            this.getSessionManager().setServerId(this.getId());
        }
        this.mAuthService = this.getAuthenticator() == null ? null : this.publish(new AuthServiceImpl<SessionClazz>(this.getAuthenticator(), this.getSessionManager()), AuthService.class);
    }

    public Server(Authenticator authenticator, SessionManager<SessionClazz> sessionManager) {
        this("0.0.0.0", 9000, authenticator, sessionManager);
    }

    public Server() {
        this(null, null);
    }

    public Authenticator getAuthenticator() {
        return this.mAuthenticator;
    }

    public SessionManager<SessionClazz> getSessionManager() {
        return this.mSessionManager;
    }

    private ServiceInterface getAuthService() {
        return this.mAuthService;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.getAuthService() != null) {
            this.getAuthService().stop();
        }
    }

    @Override
    public Server<SessionClazz> getServer() {
        return this;
    }
}

