/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import java.util.Locale;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessRemoteCall;
import org.marketcetera.util.ws.tags.TagFilter;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: StatelessRemoteRunner.java 16154 2012-07-14 16:34:05Z colin $")
public abstract class StatelessRemoteRunner
extends StatelessRemoteCall {
    public StatelessRemoteRunner(TagFilter versionIdFilter, TagFilter appIdFilter, TagFilter clientIdFilter) {
        super(versionIdFilter, appIdFilter, clientIdFilter);
    }

    public StatelessRemoteRunner() {
    }

    public void execute(StatelessClientContext context) throws RemoteException {
        Locale locale = null;
        if (context.getLocale() != null) {
            locale = (Locale)context.getLocale().getRaw();
        }
        try {
            this.startCall(context);
            ActiveLocale.pushLocale(locale);
            try {
                this.assertFilterMatch(context);
                this.run(context);
            }
            finally {
                ActiveLocale.popLocale();
            }
            this.handleSuccess(context);
        }
        catch (Throwable t) {
            throw this.wrapFailure(context, t);
        }
    }

    protected abstract void run(StatelessClientContext var1) throws Exception;
}

